using System;
using System.Collections.Generic;
using System.Text;
using de.WWWings.WCF;

namespace WindowsUI.CallCenterApp
{
 static class Dienste
 {

  public static void PingServer(ref PingInfo Info, ref int Milliseconds, ref Exception Exception)
  {
   DateTime Start = DateTime.Now;
   DateTime Ende = DateTime.MaxValue;
   TestServiceClient t = TestServiceClient;
   try
   {

    Info = t.Ping();

    Ende = DateTime.Now;
    Milliseconds = ((TimeSpan)(Ende - Start)).Milliseconds;
   }
   catch (Exception ex)
   {
    Info = null;
    Exception = ex;
   }
   finally
   {
    try
    {
     t.Close();
    }
    catch (Exception ex)
    {
     Exception = ex;
    
    }

   }
  }

  static public TestServiceClient TestServiceClient
  {
   get
   {

    TestServiceClient s = new TestServiceClient(new System.ServiceModel.InstanceContext(new PingCallback()),"TestService_" + kuerzel());
    //System.ServiceModel.OperationContext.Current.OutgoingMessageHeaders.From = new System.ServiceModel.EndpointAddress(System.Environment.MachineName);
    SetServer(s.Endpoint);
    return s;
   }
  }

  static public BuchungsServiceClient BuchungsServiceClient
  {
   get
   {
    BuchungsServiceClient s = new BuchungsServiceClient("BuchungsService_" + kuerzel());

    SetServer(s.Endpoint);
    return s;
   }
  }

  static public FlugplanverwaltungServiceClient FlugplanverwaltungServiceClient
  {
   get
   {
    FlugplanverwaltungServiceClient s = new FlugplanverwaltungServiceClient("FlugplanverwaltungService_" + kuerzel());
    SetServer(s.Endpoint);
    return s;
   }
  }

  static public PassagierverwaltungServiceClient PassagierverwaltungServiceClient
  {
   get
   {
    PassagierverwaltungServiceClient s = new PassagierverwaltungServiceClient("PassagierverwaltungService_" + kuerzel());
    SetServer(s.Endpoint);
    return s;
   }
  }



  static private void SetServer(System.ServiceModel.Description.ServiceEndpoint e)
  {
   e.Address = new System.ServiceModel.EndpointAddress(new System.Uri(e.Address.ToString().Replace("localhost", WindowsUI.Properties.Settings.Default.AppServer)));
  }

  static private string kuerzel()
  {

   string Kuerzel = WindowsUI.Properties.Settings.Default.Kommunikationsprofil;
   if (Kuerzel == "Named Pipes") Kuerzel = "PIPE";
   return Kuerzel;

  }
 }

 public class PingCallback : de.WWWings.WCF.ITestServiceCallback
 {
  #region ITestServiceCallback Members

  void ITestServiceCallback.ClientPing(string Server)
  {
   // TODO
  }

  #endregion
 }
}
