#region Using directives

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Collections.Specialized;
using System.Workflow.Activities;

#endregion

namespace de.WWWings.Workflow
{
 class WorkflowHost
 {

  public static WorkflowRuntime WorkflowRuntime = new WorkflowRuntime();
  public static ExternalDataExchangeService WFDatenDienst;
  public static SqlWorkflowPersistenceService WFPersistenzDienst;
  public static System.Workflow.Runtime.Tracking.SqlTrackingService WFTrackingDienst;

  /// <summary>
  /// Hauptprogramm fr den Workflow-Server
  /// </summary>
  public static void Start()
  {

   // Datendienst
   WFDatenDienst = new ExternalDataExchangeService();
   WorkflowHost.WorkflowRuntime.AddService(WFDatenDienst);

   // Persistenzdienst
   NameValueCollection Parameter = new NameValueCollection();
   Parameter.Add("UnloadOnIdle", "true");
   Parameter.Add("ConnectionString", WindowsUI.Properties.Settings.Default.CS_Workflow);
   WFPersistenzDienst = new SqlWorkflowPersistenceService(Parameter);
   WorkflowHost.WorkflowRuntime.AddService(WFPersistenzDienst);

   // Ablaufverfolgung
   WFTrackingDienst = new System.Workflow.Runtime.Tracking.SqlTrackingService(WindowsUI.Properties.Settings.Default.CS_Workflow);
   WorkflowHost.WorkflowRuntime.AddService(WFTrackingDienst);

   // Starten der WF-Laufzeitumgebung
   WorkflowHost.WorkflowRuntime.StartRuntime();

   // Anzeige des GUIs
   WWW_WorkflowHost.F_FlugBuchung f = new WWW_WorkflowHost.F_FlugBuchung();
   f.ShowDialog();

      WorkflowHost.WorkflowRuntime.StopRuntime();
  }



 }
}
