﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI
{
 public partial class F_MDI : Form
 {
  private int childFormNumber = 0;

  public F_MDI()
  {
   InitializeComponent();
  }

  private void ShowNewForm(object sender, EventArgs e)
  {
   // Create a new instance of the child form.
   Form childForm = new Form();
   // Make it a child of this MDI form before showing it.
   childForm.MdiParent = this;
   childForm.Text = "Window " + childFormNumber++;
   childForm.Show();
  }

  private void OpenFile(object sender, EventArgs e)
  {
   OpenFileDialog openFileDialog = new OpenFileDialog();
   openFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
   openFileDialog.Filter = "Textdateien (*.txt)|*.txt|XML-Dateien (*.xml)|*.xml";
   openFileDialog.ShowDialog(this);

   string FileName = openFileDialog.FileName;
   

  }

  private void SaveAsToolStripMenuItem_Click(object sender, EventArgs e)
  {
   SaveFileDialog saveFileDialog = new SaveFileDialog();
   saveFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
   saveFileDialog.Filter = "Text Files (*.txt)|*.txt";
   saveFileDialog.ShowDialog(this);

   string FileName = saveFileDialog.FileName;
   // TODO: Add code here to save the current contents of the form to a file.
  }

  private void ExitToolsStripMenuItem_Click(object sender, EventArgs e)
  {
   Application.Exit();
  }

  private void CutToolStripMenuItem_Click(object sender, EventArgs e)
  {
   // TODO: Use System.Windows.Forms.Clipboard to insert the selected text or images into the clipboard
  }

  private void CopyToolStripMenuItem_Click(object sender, EventArgs e)
  {
   // TODO: Use System.Windows.Forms.Clipboard to insert the selected text or images into the clipboard
  }

  private void PasteToolStripMenuItem_Click(object sender, EventArgs e)
  {
   // TODO: Use System.Windows.Forms.Clipboard.GetText() or System.Windows.Forms.GetData to retrieve information from the clipboard.
  }

  private void ToolBarToolStripMenuItem_Click(object sender, EventArgs e)
  {
   toolStrip.Visible = toolBarToolStripMenuItem.Checked;
  }

  private void StatusBarToolStripMenuItem_Click(object sender, EventArgs e)
  {
   statusStrip.Visible = statusBarToolStripMenuItem.Checked;
  }

  private void CascadeToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.Cascade);
  }

  private void TileVerticleToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.TileVertical);
  }

  private void TileHorizontalToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.TileHorizontal);
  }

  private void ArrangeIconsToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.ArrangeIcons);
  }

  private void CloseAllToolStripMenuItem_Click(object sender, EventArgs e)
  {
   foreach (Form childForm in MdiChildren)
   {
    childForm.Close();
   }
  }

  private void MDI_Load(object sender, EventArgs e)
  {
   F_Flugverwaltung_Webservice fw = new F_Flugverwaltung_Webservice();
   F_Buchungsverwaltung bw = new F_Buchungsverwaltung();
   //F_Passagierstammdaten ps = new F_Passagierstammdaten();
   //Fenster.F_Flugverwaltung_mit_Details_RAD_TDS td = new Fenster.F_Flugverwaltung_mit_Details_RAD_TDS();
   fw.MdiParent = this;
   bw.MdiParent = this;
   //ps.MdiParent = this;
   //td.MdiParent = this;
   fw.Show();
   bw.Show();
   //ps.Show();
   //td.Show();

   foreach (Form f in this.MdiChildren)
   {
    this.C_Fenster.Items.Add(f.Text);
   }
  }

  private void menuStrip_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
  {

  }

  private void C_Fenster_SelectedIndexChanged(object sender, EventArgs e)
  {
   foreach (Form f in this.MdiChildren)
   {
    if (C_Fenster.SelectedItem.ToString() == f.Text) f.BringToFront();
   }
  }
 }
}