﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI.Fenster
{
 public partial class F_Flugverwaltung_Object : Form
 {

  de.WWWings.DAL.Flug_DataManager FDM = new de.WWWings.DAL.Flug_DataManager();
  public delegate void GetDataAsyncDelegate();

  public F_Flugverwaltung_Object()
  {
   InitializeComponent();
  }

  private void F_Flugverwaltung_Object_Load(object sender, EventArgs e)
  {
   FDM_FluegeWurdenAktualisiert();
  }

  /// <summary>
  /// Maßnahmen, wenn Flüge gehollt werden sollen
  /// </summary>
  void FDM_FluegeWurdenAktualisiert()
  {
   SetWatch();  
   GetData();

  }

  /// <summary>
  /// Aktiviert Änderungsüberwachung
  /// </summary>
  void SetWatch()
  {
   FDM.AktualisierungenMelden("Berlin");
   FDM.FluegeWurdenAktualisiert += new de.WWWings.DAL.Flug_DataManager.FluegeWurdenAktualisiertHandler(FDM_FluegeWurdenAktualisiert);
  }


  private void GetData()
  {
   GetDataAsyncDelegate d = new GetDataAsyncDelegate(GetDataAsync);
   this.Invoke(d, new object[] { });
  }

  private void GetDataAsync()
  {
   de.WWWings.FlugMenge ff = de.WWWings.FlugBLManager.HoleAlle();
   this.flugBindingSource.DataSource = ff;

  }

  private void bindingNavigatorSaveItem_Click(object sender, EventArgs e)
  {
   de.WWWings.FlugMenge ff = this.flugBindingSource.DataSource as de.WWWings.FlugMenge;
    foreach (de.WWWings.Flug f in ff)
    {
     de.WWWings.FlugBLManager.SpeichereFlug(f);
    }
  }

  private void flugBindingNavigator_RefreshItems(object sender, EventArgs e)
  {

  }


 }
}