using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI.CallCenterApp
{
 public partial class F_Buchung : Form
 {



  public F_Buchung()
  {
   InitializeComponent();
  }


  public long PID = 1;
  private void F_Buchung_Load(object sender, EventArgs e)
  {
   this.C_PID.Text = PID.ToString();
   RefreshPassagier();
   RefreshStrecke();


  }

  private void RefreshPassagier()
  {
   int PID = Convert.ToInt32(this.C_PID.Text);
   p = Dienste.PassagierverwaltungServiceClient.HolePassagier(PID);
   this.C_Name.Text = p._Vorname + " " + p._Nachname;
   this.C_Buchungen.Text = Dienste.BuchungsServiceClient.HoleBuchungenFuerPassagier(PID).Length.ToString();
  }

  private void RefreshStrecke()
  {
   C_Panel.Controls.Clear();
   byte AnzStrecken = Convert.ToByte(this.C_Strecken.Text);
   if (AnzStrecken > 4) AnzStrecken = 4;
   for (byte i = 1; i <= AnzStrecken; i++)
   {
    TextBox t = new TextBox();
    t.Name = "FlugNr" + i;

    t.Location = new System.Drawing.Point(122, 33 * i);
    t.Size = new System.Drawing.Size(100, 20);
    t.Text = (100 + i).ToString();
    t.LostFocus += new EventHandler(t_TextChanged);
    t.Tag = i;
    Label l = new Label();
    l.Name = "FlugNrLabel" + i;
    l.Text = "Flug #" + i;
    l.Location = new System.Drawing.Point(31, 33 * i);
    l.Size = new System.Drawing.Size(100, 20);
    Label l2 = new Label();
    l2.Name = "Strecke" + i;
    l2.Text = Dienste.FlugplanverwaltungServiceClient.HoleFlugRoute(100 + i);
    l2.Location = new System.Drawing.Point(250, 33 * i);
    l2.Size = new System.Drawing.Size(150, 20);
    this.C_Panel.Controls.Add(t);
    this.C_Panel.Controls.Add(l);
    this.C_Panel.Controls.Add(l2);
    //MessageBox.Show(this.C_Strecken.Controls.Count.ToString());
   }
  }

  void t_TextChanged(object sender, EventArgs e)
  {
   TextBox t = (sender as TextBox);
   Byte pos = Convert.ToByte(t.Tag);
   Label l = (this.C_Panel.Controls.Find("Strecke" + pos, true)[0]) as Label;
   long FlugNr = Convert.ToInt64(t.Text);

   l.Text = Dienste.FlugplanverwaltungServiceClient.HoleFlugRoute(FlugNr);
  }

  private void groupBox1_Enter(object sender, EventArgs e)
  {

  }

  private void C_Strecken_SelectedIndexChanged(object sender, EventArgs e)
  {
   RefreshStrecke();
  }

  de.WWWings.WCF.Passagier p;

  private void C_Suchen_Click(object sender, EventArgs e)
  {
   RefreshPassagier();
  }

  private void C_Abbrechen_Click(object sender, EventArgs e)
  {
   this.Close();
  }
  long buchungscode = 0;
  private void C_Buchen_Click(object sender, EventArgs e)
  {
   if (p == null) { System.Windows.Forms.MessageBox.Show("Bitte erst Passagier auswhlen!"); return; }

   System.Collections.Generic.List<long> FlugNummern = new System.Collections.Generic.List<long>();

   byte AnzStrecken = Convert.ToByte(this.C_Strecken.Text);
   if (AnzStrecken > 4) AnzStrecken = 4;
   for (byte i = 1; i <= AnzStrecken; i++)
   {
    long FlugNr = Convert.ToInt64((this.Controls.Find("FlugNr" + i, true)[0] as TextBox).Text);
    FlugNummern.Add(FlugNr);
   }

   try
   {
    // Instanz holen
    de.WWWings.WCF.BuchungsServiceClient dienst = Dienste.BuchungsServiceClient;
    // Operation aufrufen, dadurch wird Verbindung geffnet
    buchungscode = dienst.MehrfachBuchungErstellenMitIDs(p.PID, FlugNummern.ToArray());
    // Schlieen der Verbindung
    dienst.Close();

    System.Windows.Forms.MessageBox.Show("Buchung erfolgt mit Buchungscode " + buchungscode, "Besttigung");
   }
   catch (Exception ex)
   {
    Fensterverwaltung.Zeige_Fehler(ex);
   }

  }

  private void F_Drucken_Click(object sender, EventArgs e)
  {
   if (buchungscode != 0)
   { Fensterverwaltung.Zeige_Ticketdruck(buchungscode); }
   else { MessageBox.Show("Keine aktuelle Buchung vorhanden", "Bedienungsfehler"); }


  }


 }
}