using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

 using System.Web.Security;
using System.Security.Principal;
using System.Runtime.InteropServices;

public partial class _MISC_AUFBAUWISSEN_Sicherheit_AuthDemo_CS : System.Web.UI.Page
{
 // Hilfsfunktion aus Win32 API
 [System.Runtime.InteropServices.DllImport("advapi32.dll", EntryPoint="LogonUser", ExactSpelling=false, CharSet=System.Runtime.InteropServices.CharSet.Auto, SetLastError=true)]
 public static extern int LogonUser(string lpszUsername, string lpszDomain, string lpszPassword, int dwLogonType, int dwLogonProvider, ref IntPtr phToken);
 // Hilfsfunktion aus Win32 API
 [System.Runtime.InteropServices.DllImport("advapi32.dll", EntryPoint="DuplicateToken", ExactSpelling=false, CharSet=System.Runtime.InteropServices.CharSet.Auto, SetLastError=true)]
 public static extern int DuplicateToken(IntPtr ExistingTokenHandle, int ImpersonationLevel, ref IntPtr DuplicateTokenHandle);



 public void Page_Load(object s, EventArgs e)
 {
  SicherheitsInfo();
  string username = "hp";
  string kennwort = "hp";
  string Domain = "e45";

  // Zielidentitt
  System.Security.Principal.WindowsIdentity WinIdentity = null;

  Response.Write("<h3>-> Wechsel zur spezifischen Identitt '" + Domain + "\\" + username + "'...</h3>");
  WinIdentity = ImpersonateAnyUser(username, Domain, kennwort);
  ImpersonateTest(WinIdentity);

  Response.Write("<h3>-> Wechsel zur Identitt des angemeldeten Benutzers...</h3>");
  if (Page.User.Identity.IsAuthenticated)
  {
   WinIdentity = ImpersonateAsAuthenticatedUser();
   ImpersonateTest(WinIdentity);
  }
  else
  {
   Response.Write("<h3>-> Wechsel zur Identitt des angemeldeten Benutzers nicht mglich, da kein Benutzer angemeldet ist!</h3>");
  }
 }

 // === Ausgabe der Information zu Identitt und Authentifizierung
 public void SicherheitsInfo()
 {

  Response.Write("<b>Authentifizierung</b><br>");
  Response.Write("Authentifizierung aktiv? " + Page.User.Identity.IsAuthenticated + "<br>");
  Response.Write("Angemeldete Benutzer: " + Page.User.Identity.Name + "<br>");
  Response.Write("Anmeldeart: " + Page.User.Identity.AuthenticationType + "<br>");
  Response.Write("Anmeldeobjekttyp: " + ((object)Page.User.Identity).GetType().Name + "<br>");
  // --- Ermitteln der Identitt
  Response.Write("<b>Identitt</b><br>");
  System.Security.Principal.WindowsIdentity user_identity = null;
  user_identity = System.Security.Principal.WindowsIdentity.GetCurrent();
  Response.Write("Identitt (Konto, unter dem die Anwendung im System agiert): " + user_identity.Name + "<br>");
 }

 // === Test der Impersonifizierung
 public void ImpersonateTest(System.Security.Principal.WindowsIdentity WinIdentity)
 {
  // Merken des impersonifizierten Benutzers
  WindowsImpersonationContext impersonationContext = null;
  // --- Wechseln
  if (WinIdentity == null)
  {
   Response.Write("Ermitteln der Identitt nicht mglich");
  }
  else
  {
   try
   {
	impersonationContext = WinIdentity.Impersonate();
	SicherheitsInfo();
   }
   catch (Exception ex)
   {
	Response.Write("<h3>-> Anmeldung fehlgeschlagen!</h3>");
   }
  }
  // --- Rckkehr
  Response.Write("<h3>-> Rckkehr zur alten Identitt...</h3>");
  if (impersonationContext != null)
  {
   impersonationContext.Undo();
   Response.Write("Identittswechsel wurde aufgehoben und ursprngliche Identitt wiederhergestellt!<br>");
  }
  else
  {
   Response.Write("Identittswechsel war nicht erfolgreich!<br>");
  }
  SicherheitsInfo();
 }

 // === Impersonifizieren des authentifizierten Nutzers
 private System.Security.Principal.WindowsIdentity ImpersonateAsAuthenticatedUser()
 {
  try
  {
   System.Security.Principal.WindowsIdentity WinIdentity = null;
   WinIdentity = (System.Security.Principal.WindowsIdentity)User.Identity;
   return WinIdentity;
  }
  catch (Exception ex)
  {
   return null;
  }
 }

 // === Impersonifizieren eines beliebigen Nutzers
 private System.Security.Principal.WindowsIdentity ImpersonateAnyUser(string userName, string domain, string password)
 {
  int LOGON32_LOGON_INTERACTIVE = 2;
  int LOGON32_PROVIDER_DEFAULT = 0;
  WindowsIdentity WinIdentity = null;
  IntPtr token = new IntPtr();
  IntPtr token2 = new IntPtr();
  if (LogonUser(userName, domain, password, LOGON32_LOGON_INTERACTIVE, LOGON32_PROVIDER_DEFAULT, ref token) != 0)
  {
   if (DuplicateToken(token, 2, ref token2) != 0)
   {
	WinIdentity = new WindowsIdentity(token2);
	return WinIdentity;
   }
  }
  return null;
 }

}

