Imports System.Web.Security
Imports System.Security.Principal
Imports System.Runtime.InteropServices

Partial Class AuthDemo
 Inherits System.Web.UI.Page

 ' Hilfsfunktion aus Win32 API
 Declare Auto Function LogonUser Lib "advapi32.dll" (ByVal lpszUsername As String, _
                            ByVal lpszDomain As String, _
                            ByVal lpszPassword As String, _
                            ByVal dwLogonType As Integer, _
                            ByVal dwLogonProvider As Integer, _
                            ByRef phToken As IntPtr) As Integer
 ' Hilfsfunktion aus Win32 API
 Declare Auto Function DuplicateToken Lib "advapi32.dll" _
 (ByVal ExistingTokenHandle As IntPtr, _
 ByVal ImpersonationLevel As Integer, _
                            ByRef DuplicateTokenHandle As IntPtr) As Integer

 ' === Beim Laden der Seite
 Public Sub Page_Load(ByVal s As Object, ByVal e As EventArgs) Handles MyBase.Load
  SicherheitsInfo()
  Dim username As String = "hp"
  Dim kennwort As String = "hp"
  Dim Domain As String = "e45"

  ' Zielidentitt
  Dim WinIdentity As System.Security.Principal.WindowsIdentity = Nothing

  Response.Write("<h3>-> Wechsel zur spezifischen Identitt '" & Domain & "\" & username & "'...</h3>")
  WinIdentity = ImpersonateAnyUser(username, Domain, kennwort)
  ImpersonateTest(WinIdentity)

  Response.Write("<h3>-> Wechsel zur Identitt des angemeldeten Benutzers...</h3>")
  If Page.User.Identity.IsAuthenticated Then
   WinIdentity = ImpersonateAsAuthenticatedUser()
   ImpersonateTest(WinIdentity)
  Else
   Response.Write("<h3>-> Wechsel zur Identitt des angemeldeten Benutzers nicht mglich, da kein Benutzer angemeldet ist!</h3>")
  End If
 End Sub

 ' === Ausgabe der Information zu Identitt und Authentifizierung
 Public Sub SicherheitsInfo()

  Response.Write("<b>Authentifizierung</b><br>")
  Response.Write("Authentifizierung aktiv? " & Page.User.Identity.IsAuthenticated & "<br>")
  Response.Write("Angemeldete Benutzer: " & Page.User.Identity.Name & "<br>")
  Response.Write("Anmeldeart: " & Page.User.Identity.AuthenticationType & "<br>")
  Response.Write("Anmeldeobjekttyp: " & CType(Page.User.Identity, Object).GetType().Name & "<br>")
  ' --- Ermitteln der Identitt
  Response.Write("<b>Identitt</b><br>")
  Dim user_identity As System.Security.Principal.WindowsIdentity
  user_identity = System.Security.Principal.WindowsIdentity.GetCurrent
  Response.Write("Identitt (Konto, unter dem die Anwendung im System agiert): " & user_identity.Name & "<br>")
 End Sub

 ' === Test der Impersonifizierung
 Sub ImpersonateTest(ByVal WinIdentity As System.Security.Principal.WindowsIdentity)
  ' Merken des impersonifizierten Benutzers
  Dim impersonationContext As WindowsImpersonationContext = Nothing
  ' --- Wechseln
  If WinIdentity Is Nothing Then
   Response.Write("Ermitteln der Identitt nicht mglich")
  Else
   Try
    impersonationContext = WinIdentity.Impersonate()
    SicherheitsInfo()
   Catch ex As Exception
    Response.Write("<h3>-> Anmeldung fehlgeschlagen!</h3>")
   End Try
  End If
  ' --- Rckkehr
  Response.Write("<h3>-> Rckkehr zur alten Identitt...</h3>")
  If Not impersonationContext Is Nothing Then
   impersonationContext.Undo()
   Response.Write("Identittswechsel wurde aufgehoben und ursprngliche Identitt wiederhergestellt!<br>")
  Else
   Response.Write("Identittswechsel war nicht erfolgreich!<br>")
  End If
  SicherheitsInfo()
 End Sub

 ' === Impersonifizieren des authentifizierten Nutzers
 Private Function ImpersonateAsAuthenticatedUser() As System.Security.Principal.WindowsIdentity
  Try
   Dim WinIdentity As System.Security.Principal.WindowsIdentity
   WinIdentity = CType(User.Identity, System.Security.Principal.WindowsIdentity)
   Return WinIdentity
  Catch ex As Exception
   Return Nothing
  End Try
 End Function

 ' === Impersonifizieren eines beliebigen Nutzers
 Private Function ImpersonateAnyUser(ByVal userName As String, _
 ByVal domain As String, ByVal password As String) As System.Security.Principal.WindowsIdentity
  Dim LOGON32_LOGON_INTERACTIVE As Integer = 2
  Dim LOGON32_PROVIDER_DEFAULT As Integer = 0
  Dim WinIdentity As WindowsIdentity
  Dim token As IntPtr
  Dim token2 As IntPtr
  If LogonUser(userName, domain, password, LOGON32_LOGON_INTERACTIVE, _
               LOGON32_PROVIDER_DEFAULT, token) <> 0 Then
   If DuplicateToken(token, 2, token2) <> 0 Then
    WinIdentity = New WindowsIdentity(token2)
    Return WinIdentity
   End If
  End If
  Return Nothing
 End Function

End Class
