using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Ereignisparameter fr Ereignis "EMailAdresseWurdeEingegeben"
/// </summary>
public class EMailAdresseWurdeEingegebenEventArgs : System.EventArgs
{
 public string EMailAdresse;

 public EMailAdresseWurdeEingegebenEventArgs(string EMailAdresse)
 {
  this.EMailAdresse = EMailAdresse;
 }
}


/// <summary>
///  Seitenklasse
/// </summary>
public partial class UC_GetInfoBox_ascx : UserControl
{
 #region "ffentliche Eigenschaften"
 private System.Drawing.Color _Farbe;

 public System.Drawing.Color Farbe
 {
  get { return _Farbe; }
  set { _Farbe = value; }
 }
 private string _Text;

 public string Text
 {
  get { return _Text; }
  set { _Text = value; }
 }

 private string _Antwortext = "Vielen Dank. Ihre Eingabe wurde gespeichert!";

 public string Antwortext
 {
  get { return _Antwortext; }
  set { _Antwortext = value; }
 }

 private string _EMailAdresse;

 public string EMailAdresse
 {
  get { return _EMailAdresse; }
  set { _EMailAdresse = value; }
 }

 public event System.EventHandler EMailAdresseWurdeEingegeben;

 #endregion

 void Page_Load(object sender, EventArgs e)
 {
  if (Text != null) this.C_Text.Text = this.Text;
  if (Farbe != null) this.C_Panel.BackColor = Farbe;
  if (EMailAdresse != null) this.C_EMail.Text = Text;
 }
 protected void C_Absenden_Click(object sender, EventArgs e)
 {
  if (Page.IsValid)
  {
   // Anzeige ndern
   this.C_Text.Text = this.Antwortext;
   this.C_EMail.Visible = false;
   this.C_Absenden.Visible = false;
   // Rckgabewert festlegen
   this.EMailAdresse = this.C_EMail.Text;
   // Ereignis auslsen
   if (this.EMailAdresseWurdeEingegeben != null) 
   { EMailAdresseWurdeEingegebenEventArgs args = new EMailAdresseWurdeEingegebenEventArgs(this.EMailAdresse);
   this.EMailAdresseWurdeEingegeben(this, args);

   
   }
  }
 }
}
