using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

 partial class Mitglieder_ProfilAnlegen_CS : System.Web.UI.Page
{
 private string HoleFotoPfad()
 {
  long ID = Profile.PassagierID;
  return Server.MapPath("~/App_Data/Fotos" + ID + ".jpg");
 }

 protected void Page_Load(object sender, System.EventArgs e)
 {
  string FotoDateiname = HoleFotoPfad();
  System.IO.FileInfo Fotodatei = new System.IO.FileInfo(FotoDateiname);
  if (Fotodatei.Exists)
  {
   this.C_Foto.ImageUrl = HoleFotoPfad();
   this.C_Foto.Visible = true;
   this.C_FotoInfo.Text = "Sie knnen ein neues Bild hochladen:";
  }
  else
  {
   this.C_FotoInfo.Text = "Bitte laden Sie ein Bild auf unseren Server:";
   this.C_Foto.Visible = false;
  }
 }

 protected void C_FotoHochladen_Click(object sender, System.EventArgs e)
 {
  if (this.C_FotoUpload.HasFile && this.C_FotoUpload.PostedFile.ContentLength < 1024 * 30)
  {

   this.C_UploadValidator.IsValid = true;
   string FotoDateiname = HoleFotoPfad();
   this.C_FotoUpload.SaveAs(HoleFotoPfad());
  }
  else
  {
   this.C_UploadValidator.IsValid = false;
  }
 }

  public void C_ValGeb_ServerValidate(object source, System.Web.UI.WebControls.ServerValidateEventArgs args)
 {
  string Wert = args.Value;
  System.DateTime geb = DateTime.MinValue;
  args.IsValid = false;

  if (DateTime.TryParse(Wert,out geb)) // Ist es ein Datum?
  {
   if (geb < DateTime.Now.AddYears(-18)) // lter als 18?
   {
	args.IsValid = true;
   }
  }
 }

 public void B_Eintragen_Click(object sender, System.EventArgs e)
 {
  // Speichern in Benutzerprofil

  Profile.Person.Geschlecht = this.C_Geschlecht.SelectedValue;
  Profile.Person.Geburtstag = Convert.ToDateTime(this.C_Geb.Text);
  Profile.Person.Name = this.C_Name.Text;
  Profile.Person.Vorname = this.C_Vorname.Text;
  Profile.Save();

  foreach (ListItem li in this.C_Taetigkeit.Items)
  {
   if (li.Selected)
   {
	   Profile.Person.Taetigkeiten.Add(li.Value);
   }
  }
  // ...
  // Anzeige aktualisieren
  this.C_Mehrfachansicht.SetActiveView(this.C_Eingabespeichert);

  // Zur Sicherheit: Protokollieren in Protokolldatei

  System.IO.StreamWriter sw = new System.IO.StreamWriter(Server.MapPath("~/App_Data/log.txt"));
  sw.Write("Registrierung;");
  sw.Write(DateTime.Now + ";");
  sw.Write(Profile.Person.Name + ";");
  sw.Write(Profile.Person.Vorname + ";");
  sw.Write(Profile.Person.Geburtstag + ";");
  sw.Write(Profile.Person.Geschlecht + ";");
  sw.WriteLine();
  sw.Close();

  // Erzeugung eines neuen Eintrags in einem Ereignisprotokoll

  string logname = "WWWings";
  string source = "WWWingsWeb";
  string computer = "E01";
  int EventID = 1234;
  // Quelle und ggf. Ereignisprotokoll anlegen
  if (! (System.Diagnostics.EventLog.SourceExists(source, computer)))
  {
   // Quelle anlegen
   System.Diagnostics.EventSourceCreationData escd = new System.Diagnostics.EventSourceCreationData(source, logname);
   escd.MachineName = computer;
   System.Diagnostics.EventLog.CreateEventSource(escd);
  }
  // Eintrag schreiben
  System.Diagnostics.EventLog.WriteEntry(source, "Profildaten gespeichert fr Benutzer " + Profile.Person.Vorname + " " + Profile.Person.Name, System.Diagnostics.EventLogEntryType.Information, EventID);


 }
}
