<%@ Page Language="VB" MasterPageFile="~/Master/itv.master" Title="Flugauswahl fr Profis" %>

<%@ Implements Interface="System.Web.UI.ICallbackEventHandler" %>

<script runat="server">
  Public Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
  ' Befllen der Abflugorte
  Me.C_Abflug.DataSource = de.WWWings.FlugBLManager.Abflugorte()
  Me.C_Abflug.DataBind()
  ' Binden der Skriptereignisbehandlungsroutinen fr die Auswahlfelder
  Me.C_Abflug.Attributes.Add("onchange", "AbflugortAuswahl('" & Me.C_Abflug.ClientID & "', '" & Me.C_Zielort.ClientID & "');")
  Me.C_Zielort.Attributes.Add("onchange", "ZielortAuswahl('" & Me.C_Abflug.ClientID & "', '" & Me.C_Zielort.ClientID & "');")
  ' Erstellen der Rckrufroutine
  If (Not Request.Browser.SupportsCallback) Then
   Throw New ApplicationException("Dieser Browser untersttzt keine Client-Callbacks!")
  End If
  Dim CallbackAufruf As String = Page.ClientScript.GetCallbackEventReference(Me, "argument", "CallbackErgebnis", "context", "CallbackFehler", False)
  Dim Quellcode As String = "function Callback(argument, context) { " & CallbackAufruf & "; }"
  Page.ClientScript.RegisterClientScriptBlock(Me.GetType(), "Callback", Quellcode, True)
 End Sub

 ' Zwischenspeicherung des Rckgabewertes der Rckrufroutine
 Private wert As String = ""

 ' Rckruf des Clients
 Private Sub RaiseCallbackEvent(ByVal eventArgs As String) Implements ICallbackEventHandler.RaiseCallbackEvent
  Dim eingegebeneNr As Long = 0
  If Int64.TryParse(eventArgs, eingegebeneNr) Then
   ' FlugNummer wurde bergeben
   Dim f As de.WWWings.Flug = de.WWWings.FlugBLManager.HoleFlug(eingegebeneNr)
   If Not f Is Nothing Then
	wert = "#;" & f.FlugNr & ";" & f.AbflugOrt & ";" & f.ZielOrt
   Else ' Flug wurde nicht gefunden
	wert = ""
   End If
  Else
   ' Abflugort wurde bergeben
   Dim Abflugort As String = eventArgs
   wert = String.Join(";", de.WWWings.FlugBLManager.Ziele_Fuer_Abflugort(Abflugort))

  End If
 End Sub

 ' Ergebnis an Client liefern
 Private Function GetCallbackResult() As String Implements ICallbackEventHandler.GetCallbackResult
  Return wert
 End Function
</script>

<asp:Content runat="server" ID="C1" ContentPlaceHolderID="P_MainContent">

<!--- Client-Skript --->
 <script type="text/javascript" language="javascript">
// Ereignisbehandlung fr Flugnummerneingabe
function FlugNachNummerSuchen()
{
document.all.C_Ergebnis1.innerHTML = "Ihre Eingabe wird geprft...";
var n = document.forms[0].C_FlugNr.value;
Callback(n, "C_FlugNr");
//alert("test");
}

// Tatschlicher Name des C_Zielorte-Elements
var C_Abflugort_Name;
var C_Zielort_Name;
var C_Anflugort;
var C_Zielort;
 
// Ereignisbehandlung fr Abflugauswahl
function AbflugortAuswahl(auswahl1name, auswahl2name ) {
C_Zielort_Name = auswahl2name;
C_Abflugort_Name = auswahl1name;
C_Abflugort = document.getElementById(C_Abflugort_Name);
C_Zielort = document.getElementById(C_Zielort_Name);
 
// Ermittlung der Option
var abflug = C_Abflugort.options[C_Abflugort.selectedIndex].value;
// Callback zum Server
document.all.C_Ergebnis2.innerHTML = "Lade Zielorte...";

Callback(abflug, "C_Abflug");
}

// Ereignisbehandlung fr Zielortauswahl
function ZielortAuswahl(auswahl1name, auswahl2name) {
C_Zielort_Name = auswahl2name;
C_Abflugort_Name = auswahl1name;
C_Abflugort = document.getElementById(C_Abflugort_Name);
C_Zielort = document.getElementById(C_Zielort_Name);

// Ermittlung der Option
var abflugort = C_Abflugort.options[C_Abflugort.selectedIndex].value;
var zielort = C_Zielort.options[C_Zielort.selectedIndex].value;
Ergebnis(abflugort,zielort)
}

// Ergebnis ausgeben und Link anzeigen
function Ergebnis(von, nach)
{
 ausgabe = "Sie haben gewhlt:<br>Flug von " + von + " nach " + nach;
 document.all.C_Ergebnis1.innerHTML = ausgabe;
 document.all.C_Link.href="Profibuchung.aspx?von=" + von +"&nach=" + nach;
 document.all.C_Link.style.visibility ="visible"
}

// Server hat Ergebnis geliefert
function CallbackErgebnis( result, context )
{
if (result == "")
{ // Eingegeben wurde eine Flugnummer, aber die war ungltig
document.all.C_Ergebnis1.innerHTML = "Ungltige Flugnummer!";
}
else
{ 
var liste = result.split(";");
if ( liste[0] == "#")
{ // Eingegeben wurde eine gltige Nummer

Ergebnis(liste[2],liste[3])
}
else
{
  document.all.C_Ergebnis2.innerHTML = liste.length + " Zielorte wurden gefunden.";
 // Leeren der Liste
 while (C_Zielort.options.length > 0) {
      C_Zielort.remove(0);
   }
 // Neubefllen der Liste
 for (var i=0; i<liste.length; i++) {

 C_Zielort.visible = true;
 var Option = document.createElement("option");
 Option.value = liste[i];
 Option.text= liste[i];
 C_Zielort.add(Option); 
 }
}
}
}

// Wird aufgerufen, wenn es auf dem Server zu einem Fehler kam
function CallbackFehler( error, context )
{
    alert("Fehler bei der Verarbeitung auf dem Server: " + error);
}
</script>
<!-- Ende Client-Skript -->

 <br />
 <table border="0" style="width: 100%">
  <tr>
   <td style="width: 50%" bgcolor="#ccccff">
    Flugsuche nach Flugnummer</td>
   <td style="width: 50%" bgcolor="#ccccff">
    Flugsuche nach Flughfen</td>
  </tr>
  <tr>
   <td style="width: 50%" valign="top">
    Bitte geben Sie eine gltige Flugnummer ein:
    <input id="C_FlugNr" name="C_FlugNr" type="text" value="101" />
    <button id="C_Validate" onclick="FlugNachNummerSuchen()">
     Prfen</button>
   </td>
   <td style="width: 50%" valign="top">
    Whlen Sie erst einen Abflugort:
    <asp:DropDownList ID="C_Abflug" runat="server" AppendDataBoundItems="true">
     <asp:ListItem>Bitte whlen</asp:ListItem>
    </asp:DropDownList><br />
    <div id="C_Ergebnis2">
    </div>
    <span visible="false" id="C_Zielort_Label">Whlen Sie dann einen Zielort:</span>
    <asp:DropDownList ID="C_Zielort" runat="server">
     <asp:ListItem>Bitte erst Abflug whlen</asp:ListItem>
    </asp:DropDownList></td>
  </tr>
 </table>
 <center>
  <div id="C_Ergebnis1">
  </div>
  <a id="C_Link" style="visibility: hidden;" href="Profibuchung.aspx?flugNr=">Diesen
   Flug buchen</a></center>
</asp:Content>
