﻿
Partial Class Buchung_Buchungsassistent
 Inherits System.Web.UI.Page

 ''' <summary>
 ''' Laden der Seite, Befüllen des 1. DropDown
 ''' </summary>
 Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
  If Not Page.IsPostBack Then
   Me.C_Ablugort.DataSource = de.WWWings.FlugBLManager.Abflugorte
   Me.C_Ablugort.DataBind()
  End If
 End Sub

 ''' <summary>
 ''' Ausführung nach der Fertigstellung des Assistenten
 ''' </summary>
 Protected Sub C_Buchungsassistent_FinishButtonClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles C_Buchungsassistent.FinishButtonClick
  Dim p As New DE.WWWings.PassagierSystem.Passagier(Session("PassagierID"))
  Dim buchungscode As Long = p.Buchen(Me.C_Flugmoeglichkeiten.SelectedValue)
  Trace.Write("Flug gebucht!")  ' nur zum Test

  Const StandardPreis As Long = 100
  Dim EmpfaengerEMail As String = Membership.GetUser(Me.User.Identity.Name).Email
  Dim AbsenderEMail As String = "Buchungssystem@e01.it-visions.local"
  ' --- Senden einer Bestätigungsemails
  '  Nachrichtentext
  Dim body As String = ""
  body &= "Vielen Dank für Ihre Buchung" & vbCrLf
  body &= "Flug: " & Me.C_Flugmoeglichkeiten.SelectedValue & vbCrLf
  body &= "Von: " & Me.C_Ablugort.Text & vbCrLf
  body &= "Nach: " & Me.C_Zielort.Text & vbCrLf
  body &= "Personen: " & (CInt(Me.C_Personenzahl.Text) * StandardPreis).ToString("C") & vbCrLf
  body &= "Preis: " & Me.C_Personenzahl.Text & vbCrLf
  body &= "Ihr Buchungscode: " & buchungscode
  '  Nachrichtenobjekt erzeugen
  Dim message As System.Net.Mail.MailMessage = New System.Net.Mail.MailMessage(AbsenderEMail, EmpfaengerEMail)
  message.Subject = "Buchungsbestätigung"
  message.Body = body
  ' Anhang hinzufügen
  Dim file As String = Me.Server.MapPath("Buchungsinformationen.txt")
  Dim attach As System.Net.Mail.Attachment = New System.Net.Mail.Attachment(file)
  Dim disposition As System.Net.Mime.ContentDisposition = attach.ContentDisposition
  disposition.CreationDate = System.IO.File.GetCreationTime(file)
  disposition.ModificationDate = System.IO.File.GetLastWriteTime(file)
  disposition.ReadDate = System.IO.File.GetLastAccessTime(file)
  message.Attachments.Add(attach)
  ' Nachricht senden
  Dim client As System.Net.Mail.SmtpClient = New System.Net.Mail.SmtpClient()
  ' --> Mailserver ohne web.config
  ' Dim client As System.Net.Mail.SmtpClient = New System.Net.Mail.SmtpClient(Server)
  ' client.Credentials = new NetworkCredential("benutzer", "kennwort");
  client.Send(message)

  ' === Erzeugung eines neuen Eintrags in einem Ereignisprotokoll
  Dim logname As String = "WWWings"
  Dim source As String = "WWWingsWeb"
  Dim computer As String = "E01"
  Dim EventID As Integer = 6789
  ' Quelle und ggf. Ereignisprotokoll anlegen
  If ((Not System.Diagnostics.EventLog.SourceExists(source, computer))) Then
   ' Quelle anlegen
   Dim escd As System.Diagnostics.EventSourceCreationData = New System.Diagnostics.EventSourceCreationData(source, logname)
   escd.MachineName = computer
   System.Diagnostics.EventLog.CreateEventSource(escd)
  End If
  ' Eintrag schreiben
  System.Diagnostics.EventLog.WriteEntry(source, "Flugbuchung " & buchungscode, System.Diagnostics.EventLogEntryType.Information, EventID)

 End Sub

 ''' <summary>
 ''' Ausführung nach jedem Vorwärts-Schritt im Assistenten
 ''' </summary>
 Protected Sub C_Buchungsassistent_NextButtonClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles C_Buchungsassistent.NextButtonClick

  Select Case e.CurrentStepIndex
   Case 1
    ' Flugmöglichkeiten
    Dim ff As de.WWWings.FlugMenge = de.WWWings.FlugBLManager.HoleAlle(Me.C_Ablugort.SelectedValue, Me.C_Zielort.SelectedValue)
    Me.C_Flugmoeglichkeiten.DataSource = ff
    Me.C_Flugmoeglichkeiten.DataBind()
   Case 2
    ' Kreditkarte: Hier muss nichts passieren
   Case 3
    ' Zusammenfassung anzeigen
    Me.C_EndeFlugNummer.Text = Me.C_Flugmoeglichkeiten.SelectedValue
    Me.C_EndeAm.Text = Me.C_Flugmoeglichkeiten.SelectedItem.Text
    Me.C_EndeVon.Text = Me.C_Ablugort.Text
    Me.C_EndeNach.Text = Me.C_Zielort.Text
    Me.C_EndePreis.Text = (CInt(Me.C_Personenzahl.Text) * 100).ToString("C")
    Me.C_EndePersonen.Text = Me.C_Personenzahl.Text
  End Select

 End Sub

 ''' <summary>
 ''' Ausführung nach jedem Schritt im Assistenten
 ''' </summary>
 Protected Sub C_Buchungsassistent_ActiveStepChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles C_Buchungsassistent.ActiveStepChanged
  ' Response.Write("ADS") ' nur zum Test
 End Sub

 ''' <summary>
 ''' Aktion bei Abbruch des Assistenten
 ''' </summary>
 Protected Sub C_Buchungsassistent_CancelButtonClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles C_Buchungsassistent.CancelButtonClick
  Response.Redirect("Default.aspx")
 End Sub


 ''' <summary>
 ''' Auswahl Drop-Down1 befüllt DropDown 2
 ''' </summary>
 Protected Sub C_Ablugort_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles C_Ablugort.SelectedIndexChanged
  Me.C_Zielort.DataSource = de.WWWings.FlugBLManager.Ziele_Fuer_Abflugort(Me.C_Ablugort.SelectedValue.ToString())
  Me.C_Zielort.DataBind()
 End Sub
End Class
