<%@ Page Language="C#" MasterPageFile="~/Master/itv.master" Title="Flugauswahl fr Profis" %>

<%@ Implements Interface="System.Web.UI.ICallbackEventHandler" %>

<script runat="server">
 
 public void Page_Load(object sender, EventArgs e)
 {
 
  // Erstellen der Rckrufroutine
  if (!Request.Browser.SupportsCallback)
  { throw new ApplicationException("Dieser Browser untersttzt keine Client-Callbacks!"); }
  else
  {
   string CallbackAufruf = Page.ClientScript.GetCallbackEventReference(
       this, "argument", "CallbackErgebnis", "context", "CallbackFehler", false);
   string Quellcode = @"function Callback(argument, context) { " + CallbackAufruf + "; }";
   Page.ClientScript.RegisterClientScriptBlock(
       this.GetType(), "Callback", Quellcode, true);
  }


  // Befllen der Abflugorte
  this.C_Abflug.DataSource = de.WWWings.FlugBLManager.Abflugorte();
  this.C_Abflug.DataBind();
  // Binden der Skriptereignisbehandlungsroutinen fr die Auswahlfelder
  this.C_Abflug.Attributes.Add("onchange", "AbflugortAuswahl();");
  this.C_Zielort.Attributes.Add("onchange", "ZielortAuswahl();");
 }

 // Zwischenspeicherung des Rckgabewertes der Rckrufroutine
 string wert = "";

 // Rckruf des Clients
 void ICallbackEventHandler.RaiseCallbackEvent(string eventArgs)
 {
  long eingegebeneNr = 0;
  if (Int64.TryParse(eventArgs, out eingegebeneNr))
  {
   // FlugNummer wurde bergeben
    de.WWWings.Flug f;
   try
   {
   f = de.WWWings.FlugBLManager.HoleFlug(eingegebeneNr);
   }
   catch
   {
    throw new System.ApplicationException("Flug nicht gefunden! ");
   }
   
   if (f != null)
   {
    wert = "#;" + f.FlugNr + ";" + f.AbflugOrt + ";" + f.ZielOrt;
   }
   else // Flug wurde nicht gefunden
   {
    wert = "";
   }
  }
  else
  {
   // Abflugort wurde bergeben
   string Abflugort = eventArgs;
   wert = string.Join(";", de.WWWings.FlugBLManager.Ziele_Fuer_Abflugort(Abflugort));
  }
 }

 // Ergebnis an Client liefern
 string ICallbackEventHandler.GetCallbackResult()
 {
  return wert;
 }
</script>

<asp:Content runat="server" ID="C1" ContentPlaceHolderID="P_MainContent">

<!--- Client-Skript --->
 <script type="text/javascript" language="javascript">
// Ereignisbehandlung fr Flugnummerneingabe
function FlugNachNummerSuchen()
{
document.all.C_Ergebnis1.innerHTML = "Ihre Eingabe wird geprft...";
// Flugnummer auslesen
var n = document.forms[0].C_FlugNr.value;
// AJAX-Aufruf
Callback(n, "C_FlugNr");
//alert("test");
}
 
// Ereignisbehandlung fr Abflugauswahl
function AbflugortAuswahl(auswahl1name, auswahl2name ) {
C_Abflugort = document.getElementById('<%= this.C_Abflug.ClientID %>');
C_Zielort = document.getElementById('<%= this.C_Zielort.ClientID %>');
 
// Ermittlung der Option
var abflug = C_Abflugort.options[C_Abflugort.selectedIndex].value;
// Callback zum Server
document.all.C_Ergebnis2.innerHTML = "Lade Zielorte...";

Callback(abflug, "C_Abflug");
}

// Ereignisbehandlung fr Zielortauswahl
function ZielortAuswahl() {
C_Abflugort = document.getElementById('<%= this.C_Abflug.ClientID %>');
C_Zielort = document.getElementById('<%= this.C_Zielort.ClientID %>');

// Ermittlung der Option
var abflugort = C_Abflugort.options[C_Abflugort.selectedIndex].value;
var zielort = C_Zielort.options[C_Zielort.selectedIndex].value;
Ergebnis(abflugort,zielort)
}

// Ergebnis ausgeben und Link anzeigen
function Ergebnis(von, nach)
{
 ausgabe = "Sie haben gewhlt:<br>Flug von " + von + " nach " + nach;
 document.all.C_Ergebnis1.innerHTML = ausgabe;
 document.all.C_Link.href="ajax/Fortschrittsanzeige_ATLAS.aspx?von=" + von +"&nach=" + nach;
 document.all.C_Link.style.visibility ="visible"
}

// AJAX-Rckruf: Server hat Ergebnis geliefert
function CallbackErgebnis( result, context )
{
if (result == "")
{ // Eingegeben wurde eine Flugnummer, aber die war ungltig
document.all.C_Ergebnis1.innerHTML = "Ungltige Flugnummer!";
}
else
{ 
var liste = result.split(";");
if ( liste[0] == "#")
{ // Eingegeben wurde eine gltige Nummer

Ergebnis(liste[2],liste[3])
}
else
{
  document.all.C_Ergebnis2.innerHTML = liste.length + " Zielorte wurden gefunden.";
 // Leeren der Liste
 while (C_Zielort.options.length > 0) {
      C_Zielort.remove(0);
   }
 // Neubefllen der Liste
 for (var i=0; i<liste.length; i++) {

 C_Zielort.visible = true;
 var Option = document.createElement("option");
 Option.value = liste[i];
 Option.text= liste[i];
 C_Zielort.add(Option); 
 }
}
}
}

// Wird aufgerufen, wenn es auf dem Server zu einem Fehler kam
function CallbackFehler( error, context )
{
    alert("Fehler bei der AJAX-Verarbeitung auf dem Server: " + error);
}
</script>
<!-- Ende Client-Skript -->

 <br />
 <table border="0" style="width: 100%">
  <tr>
   <td style="width: 50%" bgcolor="#ccccff">
    Flugsuche nach Flugnummer</td>
   <td style="width: 50%" bgcolor="#ccccff">
    Flugsuche nach Flughfen</td>
  </tr>
  <tr>
   <td style="width: 50%" valign="top">
    Bitte geben Sie eine gltige Flugnummer ein:
    <input id="C_FlugNr" name="C_FlugNr" type="text" value="101" />
    <button id="C_Validate" onclick="FlugNachNummerSuchen()" type="button">Prfen</button>
   </td>
   <td style="width: 50%" valign="top">
    Whlen Sie erst einen Abflugort:
    <asp:DropDownList ID="C_Abflug" runat="server" AppendDataBoundItems="true">
     <asp:ListItem>Bitte whlen</asp:ListItem>
    </asp:DropDownList><br />
    <div id="C_Ergebnis2">
    </div>
    <span visible="false" id="C_Zielort_Label">Whlen Sie dann einen Zielort:</span>
    <asp:DropDownList ID="C_Zielort" runat="server">
     <asp:ListItem>Bitte erst Abflug whlen</asp:ListItem>
    </asp:DropDownList></td>
  </tr>
 </table>
 <center>
  <div id="C_Ergebnis1">
  </div>
  <a id="C_Link" style="visibility: hidden;" href="Profibuchung.aspx?flugNr=">Diesen
   Flug buchen</a></center>
 <center>
  &nbsp;</center>
 <center style="text-align: left">
  <em>DEMO: Dies ist nur ein Anwendungsfragment fr eine alternative Buchungsfunktion.</em></center>
</asp:Content>
