using de.WWWings;
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;


partial class Buchung_Buchungsassistent_CS : System.Web.UI.Page
{

 /// <summary>
 /// Ausfhrung nach der Fertigstellung des Assistenten
 /// </summary>
 protected void C_Buchungsassistent_FinishButtonClick(object sender, System.Web.UI.WebControls.WizardNavigationEventArgs e)
 {
  /// Nur zum Test, wenn Passagier vorher nicht angemeldet ist
  if (Session["PassagierID"] == null) Session["PassagierID"] = 1;
  
  // Daten beschaffen
  long passagierID = Convert.ToInt64(Session["PassagierID"]);
  long FlugNr = Convert.ToInt64(this.C_Flugmoeglichkeiten.SelectedValue);
  Response.Write("TRACE. Buche " + passagierID + " auf " + FlugNr);

  // Buchung ausfhren
  de.WWWings.PassagierSystem.Passagier p = new de.WWWings.PassagierSystem.Passagier(passagierID);
  long buchungscode = p.Buchen(FlugNr);
  Trace.Write("Gebucht: " + passagierID + " auf " + FlugNr);

  this.C_Endmeldung.Text = "Vielen Dank fr Ihre Flugbuchung.<br>Ihr Buchungscode ist: " + buchungscode + ".<br>Sie erhalten in Krze eine E-Mail mit der Buchungsbesttigung.";

  long StandardPreis = 100;
  //string EmpfaengerEMail = Membership.GetUser(this.User.Identity.Name).Email;
  //string AbsenderEMail = "Buchungssystem@e01.it-visions.local";
  //// --- Senden einer Besttigungsemails
  ////  Nachrichtentext
  //string body = "";
  //body += "Vielen Dank fr Ihre Buchung" + System.Environment.NewLine;
  //body += "Flug: " + this.C_Flugmoeglichkeiten.SelectedValue + System.Environment.NewLine;
  //body += "Von: " + this.C_Abflugort.Text + System.Environment.NewLine;
  //body += "Nach: " + this.C_Zielort.Text + System.Environment.NewLine;
  //body += "Personen: " + (System.Convert.ToInt32(this.C_Personenzahl.Text) * StandardPreis).ToString("C") + System.Environment.NewLine;
  //body += "Preis: " + this.C_Personenzahl.Text + System.Environment.NewLine;
  //body += "Ihr Buchungscode: " + buchungscode;
  ////  Nachrichtenobjekt erzeugen
  //System.Net.Mail.MailMessage message = new System.Net.Mail.MailMessage(AbsenderEMail, EmpfaengerEMail);
  //message.Subject = Resources.MailTexte.ConfirmationSubject;
  //message.Body = body;
  //// Anhang hinzufgen
  //string file = this.Server.MapPath("Buchungsinformationen.txt");
  //System.Net.Mail.Attachment attach = new System.Net.Mail.Attachment(file);
  //System.Net.Mime.ContentDisposition disposition = attach.ContentDisposition;
  //disposition.CreationDate = System.IO.File.GetCreationTime(file);
  //disposition.ModificationDate = System.IO.File.GetLastWriteTime(file);
  //disposition.ReadDate = System.IO.File.GetLastAccessTime(file);
  //message.Attachments.Add(attach);
  //// Nachricht senden
  //System.Net.Mail.SmtpClient client = new System.Net.Mail.SmtpClient();
  //// --> Alternative: Mailserver ohne web.config
  //// Dim client As System.Net.Mail.SmtpClient = New System.Net.Mail.SmtpClient(Server)
  //// client.Credentials = new NetworkCredential("benutzer", "kennwort");
  //client.Send(message);

  // === Erzeugung eines neuen Eintrags in einem Ereignisprotokoll
  string logname = "WWWings";
  string source = "WWWingsWeb";
  string computer = "E01";
  int EventID = 6789;
  // Quelle und ggf. Ereignisprotokoll anlegen
  if (!(System.Diagnostics.EventLog.SourceExists(source, computer)))
  {
   // Quelle anlegen
   System.Diagnostics.EventSourceCreationData escd = new System.Diagnostics.EventSourceCreationData(source, logname);
   escd.MachineName = computer;
   System.Diagnostics.EventLog.CreateEventSource(escd);
  }
  // Eintrag schreiben
  System.Diagnostics.EventLog.WriteEntry(source, "Flugbuchung " + buchungscode, System.Diagnostics.EventLogEntryType.Information, EventID);
 }

 

 /// <summary>
 /// Aktion bei Abbruch des Assistenten
 /// </summary>
 protected void C_Buchungsassistent_CancelButtonClick(object sender, System.EventArgs e)
 {
  Response.Redirect("Default.aspx");
 }

 protected void Page_Load(object sender, System.EventArgs e)
 {
  if (!Page.IsPostBack)
  {
   this.C_Abflugort.DataSource = de.WWWings.FlugBLManager.Abflugorte();
   this.C_Abflugort.DataBind();
  }
 }

 protected void C_Abflugort_SelectedIndexChanged1(object sender, EventArgs e)
 {
  this.C_Zielort.DataSource = de.WWWings.FlugBLManager.Ziele_Fuer_Abflugort(this.C_Abflugort.SelectedValue.ToString());
  this.C_Zielort.DataBind();
 }

 /// <summary>
 /// Ausfhrung nach jedem Vorwrts-Schritt im Assistenten
 /// </summary>

 protected void C_Buchungsassistent_NextButtonClick(object sender, WizardNavigationEventArgs e)
 {
  switch (e.CurrentStepIndex)
  {
   case 0:
    // Flugmglichkeiten
    this.C_Flugmoeglichkeiten.DataSource = de.WWWings.FlugBLManager.HoleAlle(this.C_Abflugort.SelectedValue, this.C_Zielort.SelectedValue);
    Page.DataBind();


    break;
   case 1:
    // Kreditkarte: Hier muss nichts passieren
    break;
   case 2:
    // Zusammenfassung anzeigen
    this.C_EndeFlugNummer.Text = this.C_Flugmoeglichkeiten.SelectedValue;
    this.C_EndeAm.Text = this.C_Flugmoeglichkeiten.SelectedItem.Text;
    this.C_EndeVon.Text = this.C_Abflugort.Text;
    this.C_EndeNach.Text = this.C_Zielort.Text;
    this.C_EndePreis.Text = (System.Convert.ToInt32(this.C_Personenzahl.Text) * 100).ToString("C");
    this.C_EndePersonen.Text = this.C_Personenzahl.Text;
    break;
  }
 }
 protected void C_Buchungsassistent_ActiveStepChanged1(object sender, EventArgs e)
 {

 }
}
