Imports System
Imports System.Web
Imports System.Web.Security
Imports System.DirectoryServices
Imports System.Security.Principal
''' <summary>
''' Summary description for Authentifierung
''' </summary>

Public Class WindowsAuthentifizierung_VB2

 ' Authentifizierung mit System.DirectoryServices/ADSI
 Public Shared Function IsADSIAuthentifizierbar(ByVal Pfad As String, ByVal Domain As String, ByVal BenutzerName As String, ByVal Kennwort As String) As Boolean
  Dim VollstaendigerBenutzerName As String = Domain & "\" & BenutzerName
  System.Diagnostics.Debug.WriteLine(Pfad)
  Dim Eintrag As DirectoryEntry = New DirectoryEntry(Pfad, VollstaendigerBenutzerName, Kennwort)
  Try
   System.Diagnostics.Debug.WriteLine(VollstaendigerBenutzerName)
   Dim Objekt As Object = Eintrag.NativeObject
   Return True
  Catch Exc As Exception
   System.Diagnostics.Trace.WriteLine(Exc.Message)
   Return False
  End Try
 End Function

 ' Authentifizierung mit Win32-API
 Public Shared Function IsWin32Authentifizierbar(ByVal Domain As String, ByVal Benutzername As String, ByVal Kennwort As String) As Boolean
  Dim wi As System.Security.Principal.WindowsIdentity = WindowsAuthentifizierung_VB2.ImpersonateAnyUser(Benutzername, Domain, Kennwort)
  Return (Not wi Is Nothing)
 End Function

 ' Hilfsfunktionen aus Win32 API
 <System.Runtime.InteropServices.DllImport("advapi32.dll", EntryPoint:="LogonUser", ExactSpelling:=False, CharSet:=System.Runtime.InteropServices.CharSet.Auto, SetLastError:=True)> _
 Private Shared Function LogonUser(ByVal lpszUsername As String, ByVal lpszDomain As String, ByVal lpszPassword As String, ByVal dwLogonType As Integer, ByVal dwLogonProvider As Integer, ByRef phToken As IntPtr) As Integer
 End Function
 <System.Runtime.InteropServices.DllImport("advapi32.dll", EntryPoint:="DuplicateToken", ExactSpelling:=False, CharSet:=System.Runtime.InteropServices.CharSet.Auto, SetLastError:=True)> _
 Private Shared Function DuplicateToken(ByVal ExistingTokenHandle As IntPtr, ByVal ImpersonationLevel As Integer, ByRef DuplicateTokenHandle As IntPtr) As Integer
 End Function

 ' === Impersonifizieren eines beliebigen Nutzers
 Private Shared Function ImpersonateAnyUser(ByVal userName As String, ByVal domain As String, ByVal password As String) As System.Security.Principal.WindowsIdentity
  Dim LOGON32_LOGON_INTERACTIVE As Integer = 2
  Dim LOGON32_PROVIDER_DEFAULT As Integer = 0
  Dim WinIdentity As WindowsIdentity
  Dim token As IntPtr = New IntPtr()
  Dim token2 As IntPtr = New IntPtr()
  If LogonUser(userName, domain, password, LOGON32_LOGON_INTERACTIVE, LOGON32_PROVIDER_DEFAULT, token) <> 0 Then
   If DuplicateToken(token, 2, token2) <> 0 Then
    WinIdentity = New WindowsIdentity(token2)
    Return WinIdentity
   End If
  End If
  Return Nothing
 End Function

End Class

