Imports System.ComponentModel
Imports System.Web.UI
Imports System.Drawing.Design
Imports System.Web.UI.WebControls


Public Class ErweiterteTextbox2
 Inherits System.Web.UI.WebControls.TextBox

 ' --- Das Label
 Dim _Label As String = "Label"

 <Category("Customized"), Browsable(True)> _
 Public Property Label() As String
  Get
   Return _Label
  End Get
  Set(ByVal Value As String)
   _Label = Value
  End Set
 End Property

 ' --- Position des Labels
 Enum LabelPositionsType
  Oben
  Unten
  Rechts
  Links
 End Enum

 Dim _LabelPosition As LabelPositionsType = LabelPositionsType.Links

 <Category("Customized"), Browsable(True)> _
 Public Property LabelPosition() As LabelPositionsType
  Get
   Return _LabelPosition
  End Get
  Set(ByVal Value As LabelPositionsType)
   _LabelPosition = Value
  End Set
 End Property

 ' --- Style des Labels
 Dim _LabelStyle As String

 <Category("Customized"), Browsable(True)> _
 Public Property LabelStyle() As String
  Get
   Return _LabelStyle
  End Get
  Set(ByVal Value As String)
   _LabelStyle = Value
  End Set
 End Property

 ' --- Style der Textbox
 Dim _TextboxStyle As String

 <Category("Customized"), Browsable(True)> _
 Public Property TextboxStyle() As String
  Get
   Return _TextboxStyle
  End Get
  Set(ByVal Value As String)
   _TextboxStyle = Value
  End Set
 End Property

 <Category("Customized"), Editor("System.Web.UI.Design.ImageUrlEditor", GetType(UITypeEditor)), Browsable(True)> _
  Public Property Symbol() As String
  Get
   Dim _Symbol As String = CStr(ViewState("Symbol"))
   Return _Symbol
  End Get
  Set(ByVal Value As String)
   ViewState("Symbol") = Value
   ChildControlsCreated = False
  End Set
 End Property

 Protected Overrides Sub Render(ByVal writer As HtmlTextWriter)

  Dim _LabelControl As New Label()

  ' --- Label initialisieren
  _LabelControl.Text = _Label
  If _LabelStyle <> "" Then
   _LabelControl.CssClass = _LabelStyle
  End If

  ' --- Label oben ausgeben
  If _LabelPosition = LabelPositionsType.Oben Then
   _LabelControl.RenderControl(writer)
   'writer.Write(_Label)
   writer.Write("<br>")
  End If

  ' --- Label links ausgeben
  If _LabelPosition = LabelPositionsType.Links Then
   'writer.Write(_Label)
   _LabelControl.RenderControl(writer)
   writer.Write("&nbsp;")
  End If

  ' --- Methoden der Ursprungsklasse verwenden
  If _TextboxStyle <> "" Then
   MyBase.CssClass = _TextboxStyle
  End If

  MyBase.Render(writer)

  ' --- Label unten ausgeben
  If _LabelPosition = LabelPositionsType.Unten Then
   writer.Write("<br>")
   _LabelControl.RenderControl(writer)
  End If

  ' --- Label rechts ausgeben
  If _LabelPosition = LabelPositionsType.Rechts Then
   writer.Write("&nbsp;")
   _LabelControl.RenderControl(writer)
  End If

 End Sub

End Class
