Imports System
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.ComponentModel
Imports System.Diagnostics

Public Class BeschrifteteTextBox
    Inherits TextBox

    ' === Label, das der TextBox hinzugefgt wird.
    Dim C_BeschriftungsLabel As Label

    ' === Die Beschriftung 
    Dim C_BeschriftungsText As String = "Beschriftung"
    <Description("Die Beschriftung der Textbox"), _
    Category("Darstellung")> _
    Public Property Beschriftung() As String
        <DebuggerStepThrough()> Get
            Return C_BeschriftungsText
        End Get
        <DebuggerStepThrough()> Set(ByVal Value As String)
            C_BeschriftungsText = Value
        End Set
    End Property

    ' === Das Aussehen der Beschriftung
    Dim C_BeschriftungsStyle As String = ""
    <Description("Die Cascading StyleSheet Klasse fr die Beschriftung"), _
    Category("Darstellung")> _
    Public Property BeschriftungsStyle() As String
        <DebuggerStepThrough()> Get
            Return C_BeschriftungsStyle
        End Get
        <DebuggerStepThrough()> Set(ByVal Value As String)
            C_BeschriftungsStyle = Value
        End Set
    End Property

    ' === Ausrichtungsarten
    Enum Ausrichtung As Byte
        Links
        Oben
        Rechts
        Unten
    End Enum

    ' === Ausrichtung des Labels
    Dim C_BeschriftungsAusrichtung As Ausrichtung = Ausrichtung.Links
    <Description("Die Ausrichtung der Beschriftung im Verhltnis zur TextBox"), _
    Category("Darstellung"), _
    DefaultValue("Links")> _
        Public Property BeschriftungsAusrichtung() As Ausrichtung
        <DebuggerStepThrough()> Get
            Return C_BeschriftungsAusrichtung
        End Get
        <DebuggerStepThrough()> Set(ByVal Value As Ausrichtung)
            C_BeschriftungsAusrichtung = Value
        End Set
    End Property

    Protected Overrides Sub Render(ByVal Ausgabe As HtmlTextWriter)

        EnsureChildControls()
        
        '    '' --- Anlegen der Beschriftung
        '    'C_BeschriftungsLabel.Text = Beschriftung

        '    '' --- Zuweisen des Styles
        '    'If BeschriftungsStyle <> "" Then
        '    '    C_BeschriftungsLabel.CssClass = BeschriftungsStyle
        '    'End If

        '    '' --- Erstellen der eigentlichen Darstellung
        '    'If BeschriftungsAusrichtung = Ausrichtung.Links Then
        '    '    ' --- Label wird links ausgegeben

        '    '    ' --- Label
        '    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

        '    '    ' --- Leerzeichen
        '    '    Ausgabe.Write(HtmlTextWriter.SpaceChar)

        '    '    ' --- Textbox
        '    '    MyBase.Render(Ausgabe)

        '    'ElseIf BeschriftungsAusrichtung = Ausrichtung.Oben Then
        '    '    ' --- Label wird oben ausgegeben

        '    '    ' --- Label
        '    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

        '    '    ' --- Zeilenumbruch
        '    '    Ausgabe.Write("<br>")

        '    '    ' --- Textbox
        '    '    MyBase.Render(Ausgabe)

        '    'ElseIf BeschriftungsAusrichtung = Ausrichtung.Rechts Then
        '    '    ' --- Label wird rechts ausgegeben

        '    '    ' --- Textbox
        '    '    MyBase.Render(Ausgabe)

        '    '    ' --- Leerzeichen
        '    '    Ausgabe.Write(HtmlTextWriter.SpaceChar)

        '    '    ' --- Label
        '    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

        '    'ElseIf BeschriftungsAusrichtung = Ausrichtung.Unten Then
        '    '    ' --- Label wird unten ausgegeben

        '    '    ' --- Textbox
        '    '    MyBase.Render(Ausgabe)

        '    '    ' --- Zeilenumbruch
        '    '    Ausgabe.Write("<br>")

        '    '    ' --- Label
        '    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

        '    'End If

        '    'Ausgabe.RenderEndTag()

    End Sub

    Protected Overrides Sub CreateChildControls()
        C_BeschriftungsLabel = New Label()
        C_BeschriftungsLabel.Text = Beschriftung
        Me.Controls.AddAt(0, C_BeschriftungsLabel)
    End Sub

End Class
