' ///////////////////////////////////////////////////////////
' /Steuerelemente/DatumZeitAnzeige.vb
' ///////////////////////////////////////////////////////////

Imports System.Web.UI
Imports System.Web.UI.Design
Imports System.Web.UI.WebControls
Imports System.ComponentModel


' ### Definition des DatumZeit-Steuerelementes

<System.Web.UI.PartialCaching(10, "*", "", "")> _
<Designer(GetType(DatumZeitAnzeigeDesign))> _
Public Class DatumZeitAnzeige
    Inherits WebControl

    ' ==== Formate fr die Uhrzeitdarstellung
    Enum UhrzeitFormatType As Byte
        Keine
        Kurzformat
        Langformat
    End Enum

    ' ==== Formate fr die Datumsdarstellung
    Enum DatumFormatType As Byte
        Keine
        Kurzformat
        Langformat
    End Enum

    ' === Attribute

    ' === Soll die Systemzeit verwendet werden?
    Dim _SystemDatumZeit As Boolean = True
    <Description("Gibt an ob automatisch die aktuelle Systemzeit verwendet werden soll, oder der manuell gesetzte Wert."), _
    Category("Darstellung"), _
    Bindable(False), _
    DefaultValue(True)> _
    Public Property SystemDatumZeit() As Boolean
        Get
            Return _SystemDatumZeit
        End Get
        Set(ByVal Value As Boolean)
            If Value = True Then
                DatumZeit = Nothing
            End If
            _SystemDatumZeit = Value
        End Set
    End Property

    ' === bergebener Datums- und Zeitwert, falls die Systemzeit nicht bernommen wird.
    Dim _DatumZeit As Date
    <Bindable(True), _
    Category("Daten"), _
    Description("Datums- und Zeitwert")> _
    Public Property DatumZeit() As Date
        Get
            Return _DatumZeit
        End Get
        Set(ByVal Value As Date)
            SystemDatumZeit = False
            _DatumZeit = Value
        End Set
    End Property

    ' === Darstellung beider Werte nebeneinander?
    Dim _Nebeneinander As Boolean
    <Description("Gibt die Ausrichtung von Datum und Uhrzeit zueinander an."), _
    Category("Darstellung"), _
    DefaultValue(True)> _
    Public Property Nebeneinander() As Boolean
        Get
            Return _Nebeneinander
        End Get
        Set(ByVal Value As Boolean)
            _Nebeneinander = Value
        End Set
    End Property

    ' === Darstellungsformat fr die Uhrzeit
    Dim _UhrzeitStyle As UhrzeitFormatType = UhrzeitFormatType.Kurzformat
    <Description("Format der Uhrzeit"), _
    Category("Darstellung"), _
    DefaultValue(UhrzeitFormatType.Kurzformat)> _
    Public Property UhrzeitFormat() As UhrzeitFormatType
        Get
            Return _UhrzeitStyle
        End Get
        Set(ByVal Value As UhrzeitFormatType)
            _UhrzeitStyle = Value
        End Set
    End Property

    ' === Darstellungsformat fr das Datum
    Dim _DatumFormat As DatumFormatType = DatumFormatType.Kurzformat
    <Description("Anzeigeformat des Datums"), _
    Category("Darstellung"), _
    DefaultValue(DatumFormatType.Kurzformat)> _
    Public Property DatumsAnzeige() As DatumFormatType
        Get
            Return _DatumFormat
        End Get
        Set(ByVal Value As DatumFormatType)
            _DatumFormat = Value
        End Set
    End Property

    ' === Methoden

    ' === Erzeugen der Darstellung
    Protected Overrides Sub Render(ByVal Ausgabe As HtmlTextWriter)

        Dim _TempDatumZeit As Date

        If SystemDatumZeit Then
            _TempDatumZeit = Now
        Else
            _TempDatumZeit = DatumZeit
        End If

        Ausgabe.WriteBeginTag("span")
        Ausgabe.Write(HtmlTextWriter.TagRightChar)

        If DatumsAnzeige = DatumFormatType.Kurzformat Then
            Ausgabe.Write(_TempDatumZeit.ToShortDateString())
        ElseIf DatumsAnzeige = DatumFormatType.Langformat Then
            Ausgabe.Write(_TempDatumZeit.ToLongDateString())
        End If

        If DatumsAnzeige <> DatumFormatType.Keine And UhrzeitFormat <> UhrzeitFormatType.Keine Then
            If Nebeneinander Then
                Ausgabe.Write("&nbsp;")
            Else
                Ausgabe.Write("<br>")
            End If
        End If

        If UhrzeitFormat = DatumFormatType.Kurzformat Then
            Ausgabe.Write(_TempDatumZeit.ToShortTimeString())
        ElseIf UhrzeitFormat = DatumFormatType.Langformat Then
            Ausgabe.Write(_TempDatumZeit.ToLongTimeString)
        End If

        Ausgabe.WriteEndTag("span")
    End Sub

End Class
