Imports System.ComponentModel
Imports System.Web.UI
Imports System.Web.UI.WebControls

<DefaultProperty("Text"), _
ToolboxData("<{0}:ZusammengesetzteTextBox runat=server></{0}:ZusammengesetzteTextBox>")> _
Public Class ZusammengesetzteTextBox
    Inherits System.Web.UI.WebControls.WebControl
    Implements INamingContainer

    Dim C_Label As New Label()
    Dim C_TextBox As New TextBox()

    Dim _Text As String
    <Description("Der eingegebene Text des Steuerelemente"), _
    Category("Daten"), _
    DefaultValue("<Bitte eingeben>")> _
    Public Property [Text]() As String
        Get
            Return _Text
        End Get
        Set(ByVal Value As String)
            _Text = Value
        End Set
    End Property

    Dim _Label As String
    Public Property Label() As String
        Get
            Return _Label
        End Get
        Set(ByVal Value As String)
            _Label = Value
        End Set
    End Property

    Dim _LabelAusrichtung As LabelAusrichtungsArten
    Public Property LabelAusrichtung() As LabelAusrichtungsArten
        Get
            Return _LabelAusrichtung
        End Get
        Set(ByVal Value As LabelAusrichtungsArten)
            _LabelAusrichtung = Value
        End Set
    End Property

    Enum LabelAusrichtungsArten As Integer
        oben
        unten
        rechts
        links
    End Enum

    Protected Overrides Sub CreateChildControls()

        C_Label = New Label()
        C_TextBox = New TextBox()

        C_Label.Text = _Label
        C_TextBox.Text = _Text

    End Sub

    Protected Overrides Sub RenderChildren(ByVal writer As System.Web.UI.HtmlTextWriter)
        If LabelAusrichtung = LabelAusrichtungsArten.links Then
            Controls.Add(C_Label)
            Controls.Add(New LiteralControl("&nbsp;"))
            Controls.Add(C_TextBox)
        ElseIf LabelAusrichtung = LabelAusrichtungsArten.rechts Then
            Controls.Add(C_TextBox)
            Controls.Add(New LiteralControl("&nbsp;"))
            Controls.Add(C_Label)
        ElseIf LabelAusrichtung = LabelAusrichtungsArten.oben Then
            Controls.Add(C_Label)
            Controls.Add(New LiteralControl("<br>"))
            Controls.Add(C_TextBox)
        ElseIf LabelAusrichtung = LabelAusrichtungsArten.unten Then
            Controls.Add(C_TextBox)
            Controls.Add(New LiteralControl("<br>"))
            Controls.Add(C_Label)
        End If
        MyBase.RenderChildren(writer)
    End Sub

    Protected Overrides Sub Render(ByVal writer As System.Web.UI.HtmlTextWriter)
        EnsureChildControls()
        MyBase.Render(writer)
    End Sub

End Class
