//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace WWWings.WebSteuerelemente
{
	public class ErweiterteDropDownList : System.Web.UI.WebControls.DropDownList
	{

	  // --- Das Label
	  private string _Label = "Label";

	  [Category("Darstellung"), Browsable(true)]
	  public string Label
	  {
		get
		{
		  return _Label;
		}
		set
		{
		  _Label = value;
		}
	  }

	  // --- Position des Labels
	  public enum LabelPositionsType: int
	  {
		Oben,
		Rechts,
		Links
	  }

	  private LabelPositionsType _LabelPosition = LabelPositionsType.Links;

	  [Category("Darstellung"), Browsable(true)]
	  public LabelPositionsType LabelPosition
	  {
		get
		{
		  return _LabelPosition;
		}
		set
		{
		  _LabelPosition = value;
		}
	  }

	  // --- Style des Labels
	  private string _LabelStyle;

	  [Category("Darstellung"), Browsable(true)]
	  public string LabelStyle
	  {
		get
		{
		  return _LabelStyle;
		}
		set
		{
		  _LabelStyle = value;
		}
	  }

	  // --- Style der Textbox
	  private string _DropDownListStyle;

	  [Category("Darstellung"), Browsable(true)]
	  public string DropDownListStyle
	  {
		get
		{
		  return _DropDownListStyle;
		}
		set
		{
		  _DropDownListStyle = value;
		}
	  }

	  protected override void Render(HtmlTextWriter writer)
	  {

		Label _LabelControl = new Label();

		// --- Label initialisieren
		_LabelControl.Text = _Label;
		if (_LabelStyle != "")
		  _LabelControl.CssClass = _LabelStyle;

		// --- Label oben ausgeben
		if (_LabelPosition == LabelPositionsType.Oben)
		{
		  _LabelControl.RenderControl(writer);
		  //writer.Write(_Label)
		  writer.Write("<br>");
		}

		// --- Label links ausgeben
		if (_LabelPosition == LabelPositionsType.Links)
		{
		  //writer.Write(_Label)
		  _LabelControl.RenderControl(writer);
		  writer.Write("&nbsp;");
		}

		// --- Methoden der Ursprungsklasse verwenden
		if (_DropDownListStyle != "")
		  base.CssClass = _DropDownListStyle;

		base.Render(writer);

		// --- Label rechts ausgeben
		if (_LabelPosition == LabelPositionsType.Rechts)
		{
		  writer.Write("&nbsp;");
		  _LabelControl.RenderControl(writer);
		}

	  }

	}

} //end of root namespace