//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.ComponentModel;
using System.Web.UI;
using System.Drawing.Design;
using System.Web.UI.WebControls;


namespace WWWings.WebSteuerelemente
{
 public class BeschrifteteTextBox_IC2 : System.Web.UI.WebControls.TextBox
 {

  // --- Das Label
  private string _Label = "Label";

  [Category("Customized"), Browsable(true)]
  public string Label
  {
   get
   {
    return _Label;
   }
   set
   {
    _Label = value;
   }
  }

  // --- Position des Labels
  public enum LabelPositionsType : int
  {
   Oben,
   Unten,
   Rechts,
   Links
  }

  private LabelPositionsType _LabelPosition = LabelPositionsType.Links;

  [Category("Customized"), Browsable(true)]
  public LabelPositionsType LabelPosition
  {
   get
   {
    return _LabelPosition;
   }
   set
   {
    _LabelPosition = value;
   }
  }

  // --- Style des Labels
  private string _LabelStyle;

  [Category("Customized"), Browsable(true)]
  public string LabelStyle
  {
   get
   {
    return _LabelStyle;
   }
   set
   {
    _LabelStyle = value;
   }
  }

  // --- Style der Textbox
  private string _TextboxStyle;

  [Category("Customized"), Browsable(true)]
  public string TextboxStyle
  {
   get
   {
    return _TextboxStyle;
   }
   set
   {
    _TextboxStyle = value;
   }
  }

  [Category("Customized"), Editor("System.Web.UI.Design.ImageUrlEditor", typeof(UITypeEditor)), Browsable(true)]
  string _Symbol;

  public string Symbol
  {
   get
   {
    //_Symbol = System.Convert.ToString(ViewState["Symbol"]);
    return _Symbol;
   }
   set
   {
    //ViewState["Symbol"] = value;
    _Symbol = value;
    ChildControlsCreated = false;
   }
  }

  protected override void Render(HtmlTextWriter writer)
  {

   Label _LabelControl = new Label();

   // --- Label initialisieren
   _LabelControl.Text = _Label;
   if (_LabelStyle != "")
    _LabelControl.CssClass = _LabelStyle;


   if (this._Symbol != "")
   {
    writer.Write("<img src='" + this._Symbol + "'>");
   }

   // --- Label oben ausgeben
   if (_LabelPosition == LabelPositionsType.Oben)
   {
    _LabelControl.RenderControl(writer);
    //writer.Write(_Label)
    writer.Write("<br>");
   }

   // --- Label links ausgeben
   if (_LabelPosition == LabelPositionsType.Links)
   {
    //writer.Write(_Label)
    _LabelControl.RenderControl(writer);
    writer.Write("&nbsp;");
   }

   // --- Methoden der Ursprungsklasse verwenden
   if (_TextboxStyle != "")
    base.CssClass = _TextboxStyle;

   base.Render(writer);

   // --- Label unten ausgeben
   if (_LabelPosition == LabelPositionsType.Unten)
   {
    writer.Write("<br>");
    _LabelControl.RenderControl(writer);
   }

   // --- Label rechts ausgeben
   if (_LabelPosition == LabelPositionsType.Rechts)
   {
    writer.Write("&nbsp;");
    _LabelControl.RenderControl(writer);
   }

  }

 }

} //end of root namespace