//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;

namespace WWWings.WebSteuerelemente
{
 public class BeschrifteteTextBox_IC1 : TextBox
	{

		// === Label, das der TextBox hinzugefgt wird.
		private Label C_BeschriftungsLabel;

		// === Die Beschriftung 
		private string C_BeschriftungsText = "Beschriftung";
		[Description("Die Beschriftung der Textbox"), Category("Darstellung")]
		public string Beschriftung
		{
			[DebuggerStepThrough()]
			get
			{
				return C_BeschriftungsText;
			}
			[DebuggerStepThrough()]
			set
			{
				C_BeschriftungsText = value;
			}
		}

		// === Das Aussehen der Beschriftung
		private string C_BeschriftungsStyle = "";
		[Description("Die Cascading StyleSheet Klasse fr die Beschriftung"), Category("Darstellung")]
		public string BeschriftungsStyle
		{
			[DebuggerStepThrough()]
			get
			{
				return C_BeschriftungsStyle;
			}
			[DebuggerStepThrough()]
			set
			{
				C_BeschriftungsStyle = value;
			}
		}

		// === Ausrichtungsarten
		public enum Ausrichtung: byte
		{
			Links,
			Oben,
			Rechts,
			Unten
		}

		// === Ausrichtung des Labels
		private Ausrichtung C_BeschriftungsAusrichtung = Ausrichtung.Links;
		[Description("Die Ausrichtung der Beschriftung im Verhltnis zur TextBox"), Category("Darstellung"), DefaultValue("Links")]
		public Ausrichtung BeschriftungsAusrichtung
		{
			[DebuggerStepThrough()]
			get
			{
				return C_BeschriftungsAusrichtung;
			}
			[DebuggerStepThrough()]
			set
			{
				C_BeschriftungsAusrichtung = value;
			}
		}

		protected override void Render(HtmlTextWriter Ausgabe)
		{

			EnsureChildControls();

			//    '' --- Anlegen der Beschriftung
			//    'C_BeschriftungsLabel.Text = Beschriftung

			//    '' --- Zuweisen des Styles
			//    'If BeschriftungsStyle <> "" Then
			//    '    C_BeschriftungsLabel.CssClass = BeschriftungsStyle
			//    'End If

			//    '' --- Erstellen der eigentlichen Darstellung
			//    'If BeschriftungsAusrichtung = Ausrichtung.Links Then
			//    '    ' --- Label wird links ausgegeben

			//    '    ' --- Label
			//    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

			//    '    ' --- Leerzeichen
			//    '    Ausgabe.Write(HtmlTextWriter.SpaceChar)

			//    '    ' --- Textbox
			//    '    MyBase.Render(Ausgabe)

			//    'ElseIf BeschriftungsAusrichtung = Ausrichtung.Oben Then
			//    '    ' --- Label wird oben ausgegeben

			//    '    ' --- Label
			//    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

			//    '    ' --- Zeilenumbruch
			//    '    Ausgabe.Write("<br>")

			//    '    ' --- Textbox
			//    '    MyBase.Render(Ausgabe)

			//    'ElseIf BeschriftungsAusrichtung = Ausrichtung.Rechts Then
			//    '    ' --- Label wird rechts ausgegeben

			//    '    ' --- Textbox
			//    '    MyBase.Render(Ausgabe)

			//    '    ' --- Leerzeichen
			//    '    Ausgabe.Write(HtmlTextWriter.SpaceChar)

			//    '    ' --- Label
			//    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

			//    'ElseIf BeschriftungsAusrichtung = Ausrichtung.Unten Then
			//    '    ' --- Label wird unten ausgegeben

			//    '    ' --- Textbox
			//    '    MyBase.Render(Ausgabe)

			//    '    ' --- Zeilenumbruch
			//    '    Ausgabe.Write("<br>")

			//    '    ' --- Label
			//    '    C_BeschriftungsLabel.RenderControl(Ausgabe)

			//    'End If

			//    'Ausgabe.RenderEndTag()

		}

		protected override void CreateChildControls()
		{
			C_BeschriftungsLabel = new Label();
			C_BeschriftungsLabel.Text = Beschriftung;
			this.Controls.AddAt(0, C_BeschriftungsLabel);
		}

	}

} //end of root namespace