//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.Web.UI;
using System.ComponentModel;
using System.Web.UI.WebControls;

namespace WWWings.WebSteuerelemente
{
	public class BeschrifteteListBox : ListBox
	{

	  // === Label, das der TextBox hinzugefgt wird.
	  private Label C_BeschriftungsLabel;

	  // === Die Beschriftung 
	  private string C_BeschriftungsText = "Beschriftung";
	  [Description("Die Beschriftung der ListBox"), Category("Darstellung")]
	  public string Beschriftung
	  {
		get
		{
		  return C_BeschriftungsText;
		}
		set
		{
		  C_BeschriftungsText = value;
		}
	  }

	  // === Das Aussehen der Beschriftung
	  private string C_BeschriftungsStyle = "";
	  [Description("Die Cascading StyleSheet Klasse fr die Beschriftung"), Category("Darstellung")]
	  public string BeschriftungsStyle
	  {
		get
		{
		  return C_BeschriftungsStyle;
		}
		set
		{
		  C_BeschriftungsStyle = value;
		}
	  }

	  // === Ausrichtungsarten
	  public enum Ausrichtung: byte
	  {
		Links,
		Oben,
		Rechts,
		Unten
	  }

	  // === Ausrichtung des Labels
	  private Ausrichtung C_BeschriftungsAusrichtung = Ausrichtung.Links;
	  [Description("Die Ausrichtung der Beschriftung im Verhltnis zur TextBox"), Category("Darstellung"), DefaultValue("Links")]
	  public Ausrichtung BeschriftungsAusrichtung
	  {
		get
		{
		  return C_BeschriftungsAusrichtung;
		}
		set
		{
		  C_BeschriftungsAusrichtung = value;
		}
	  }

	  protected override void Render(HtmlTextWriter Ausgabe)
	  {

		base.AddAttributesToRender(Ausgabe);

		// --- Anlegen der Beschriftung
		C_BeschriftungsLabel = new Label();
		C_BeschriftungsLabel.Text = Beschriftung;

		// --- Zuweisen des Styles
		if (BeschriftungsStyle != "")
		  C_BeschriftungsLabel.CssClass = BeschriftungsStyle;

		// --- Erstellen der eigentlichen Darstellung
		if (BeschriftungsAusrichtung == Ausrichtung.Links)
		{
		  // --- Label wird links ausgegeben

		  // --- Label
		  C_BeschriftungsLabel.RenderControl(Ausgabe);

		  // --- Leerzeichen
		  Ausgabe.Write(HtmlTextWriter.SpaceChar);

		  // --- Textbox
		  base.Render(Ausgabe);

		}
		else if (BeschriftungsAusrichtung == Ausrichtung.Oben)
		{
		  // --- Label wird oben ausgegeben

		  // --- Label
		  C_BeschriftungsLabel.RenderControl(Ausgabe);

		  // --- Zeilenumbruch
		  Ausgabe.Write("<br>");

		  // --- Textbox
		  base.Render(Ausgabe);

		}
		else if (BeschriftungsAusrichtung == Ausrichtung.Rechts)
		{
		  // --- Label wird rechts ausgegeben

		  // --- Textbox
		  base.Render(Ausgabe);

		  // --- Leerzeichen
		  Ausgabe.Write(HtmlTextWriter.SpaceChar);

		  // --- Label
		  C_BeschriftungsLabel.RenderControl(Ausgabe);

		}
		else if (BeschriftungsAusrichtung == Ausrichtung.Unten)
		{
		  // --- Label wird unten ausgegeben

		  // --- Textbox
		  base.Render(Ausgabe);

		  // --- Zeilenumbruch
		  Ausgabe.Write("<br>");

		  // --- Label
		  C_BeschriftungsLabel.RenderControl(Ausgabe);

		}

	  }

	}

} //end of root namespace