// ////////////////////////////////////////////
// Steuerelemente/PostBackZaehler.vb
// ////////////////////////////////////////////




using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;

namespace WWWings.WebSteuerelemente
{

 /// <summary>
 /// Dieses Steuerelement speichert die Anzahl der erfolgten Postbacks im Viewstate.
 /// Bei Eintreten des 5. und des 10. PostBack wird jeweils ein Ereignis gefeuert.
 /// </summary>
 [DefaultEvent("FuenfPostBacks")]
 public class PostbackCounter2 : WebControl
 {

  public PostbackCounter2()
  {
   base.Load += new System.EventHandler(PostBackZaehler_Load);
  }

  public int AnzahlPostBacks
  {
   get
   {
    object AnzahlPostBackObject = ViewState["AnzahlPostBacks"];
    int _AnzahlPostBacks = 0;
    if (AnzahlPostBackObject == null)
     _AnzahlPostBacks = 0;
    else
     _AnzahlPostBacks = System.Convert.ToInt32(AnzahlPostBackObject);
    return _AnzahlPostBacks;
   }
   set
   {
    ViewState["AnzahlPostBacks"] = value;
   }
  }

  // === Ereignis das beim 5. PostBack feuert.
  public event EventHandler FuenfPostBacks;

  // === Ereignis das beim 10. PostBack feuert.
  public event EventHandler ZehnPostBacks;

  // === Verwenden des Load Ereignisses zum Zhlen der Postback
  private void PostBackZaehler_Load(object sender, System.EventArgs e)
  {
   if (this.Parent.Page.IsPostBack)
    AnzahlPostBacks += 1;

   if (AnzahlPostBacks == 5)
   {
    if (FuenfPostBacks != null)
     FuenfPostBacks(this, e);
   }

   if (AnzahlPostBacks == 10)
   {
    if (ZehnPostBacks != null)
     ZehnPostBacks(this, e);
   }

  }

  // === Definieren der Darstellung
  protected override void Render(HtmlTextWriter Ausgabe)
  {
   // --- Attribute fr das nchste ffnende Tag erzeugen
   AddAttributesToRender(Ausgabe);
   Ausgabe.RenderBeginTag("span");
   Ausgabe.Write("Anzahl PostBacks = " + AnzahlPostBacks);
   Ausgabe.RenderEndTag();
  }
 }
} 