
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.Design;
using System.Web.UI.WebControls;

namespace WWWings.WebSteuerelemente
{
 /// <summary>
 /// Composite Control mit Control-Designer
 /// </summary>
 [Designer(typeof(BeschrifteteTextBox_CC3_Design))]
 public class BeschrifteteTextBox_CC3 : WebControl, INamingContainer
 {

  // === Die beinhaltete Steuerelemente
  private TextBox C_Text = new TextBox();
  private Label C_Beschriftung = new Label();

  // === Mgliche Ausrichtungen fr das Label
  public enum Ausrichtung : byte
  {
   links,
   rechts,
   oben,
   unten
  }

  // === Mgliche Ausrichtungen fr den Warnhinweis
  public enum WarnungAusrichtung : byte
  {
   rechts,
   unten
  }

  #region Attribute

  // === Attribute 
  [DefaultValue("Beschriftung"), Category("Darstellung")]
  public string Beschriftung
  {
   get
   {
    return C_Beschriftung.Text;
   }
   set
   {
    C_Beschriftung.Text = value;
    ChildControlsCreated = false;
   }
  }

  [DefaultValue(Ausrichtung.links), Category("Darstellung")]
  public Ausrichtung BeschriftungAusrichtung
  {
   get
   {
    Ausrichtung _BeschriftungAusrichtung = Ausrichtung.links;
    if (ViewState["BeschriftungAusrichtung"] != null) _BeschriftungAusrichtung = (Ausrichtung) (ViewState["BeschriftungAusrichtung"]);
    return _BeschriftungAusrichtung;
   }
   set
   {
    ViewState["BeschriftungAusrichtung"] = value;
    ChildControlsCreated = false;
   }
  }

  [Category("Daten"), Description("Der eigentliche Text")]
  public string Text
  {
   get
   {
    return C_Text.Text;
   }
   set
   {
    C_Text.Text = value;
    ChildControlsCreated = false;
   }
  }

  [Category("Darstellung"), Description("Gibt an ob die Eingabe erforderlich ist"), DefaultValue(true)]
  public bool EingabeErforderlich
  {
   get
   {
    if ((ViewState["EingabeErforderlich"] == null))
     return true;
    else
    {
     bool _EingabeErforderlich = System.Convert.ToBoolean(ViewState["EingabeErforderlich"]);
     return _EingabeErforderlich;
    }
   }
   set
   {
    ViewState["EingabeErforderlich"] = value;
    ChildControlsCreated = false;
   }
  }

  [Category("Darstellung"), Description("Text der als Warnung ausgegeben wird falls eingabe nicht erfolgte.")]
  public string EingabeFehltWarnung
  {
   get
			{
    string _EingabeFehltWarnung = "";
      if (ViewState["EingabeFehltWarnung"] != null) _EingabeFehltWarnung = System.Convert.ToString(ViewState["EingabeFehltWarnung"]);
				return _EingabeFehltWarnung;
			}
			set
			{
				ViewState["EingabeFehltWarnung"] = value;
				ChildControlsCreated = false;
			}
		}

   [Category("Darstellung"), Description("An welcher Position soll die Warnung ausgegeben werden.")]
   public WarnungAusrichtung WarnungPosition
   {
    get
    {
     WarnungAusrichtung _WarnungPosition = WarnungAusrichtung.unten;
     if (ViewState["WarnungPosition"] != null) _WarnungPosition =        (WarnungAusrichtung)(ViewState["WarnungPosition"]);
     return _WarnungPosition;
    }
    set
    {
     ViewState["WarnungPosition"] = value;
     ChildControlsCreated = false;
    }
   }

   public override ControlCollection Controls
   {
    get
    {
     EnsureChildControls();
     return base.Controls;
    }
   }

  #endregion

   #region Methoden

   // === Methoden
   protected override void CreateChildControls()
   {

    C_Beschriftung.Text = "Label";

    C_Text.ID = "text1";
    C_Text.Text = Text;

    if (BeschriftungAusrichtung == Ausrichtung.links)
    {
     // --- Beschriftung ist links
     Controls.Add(C_Beschriftung);
     Controls.Add(new LiteralControl("&nbsp;"));
     Controls.Add(C_Text);

    }
    else if (BeschriftungAusrichtung == Ausrichtung.oben)
    {
     // --- Beschriftung ist oben
     Controls.Add(C_Beschriftung);
     Controls.Add(new LiteralControl("<br>"));
     Controls.Add(C_Text);

    }
    else if (BeschriftungAusrichtung == Ausrichtung.rechts)
    {
     // --- Beschriftung ist rechts
     Controls.Add(C_Text);
     Controls.Add(new LiteralControl("&nbsp;"));
     Controls.Add(C_Beschriftung);

    }
    else if (BeschriftungAusrichtung == Ausrichtung.unten)
    {
     // --- Beschriftung ist unten
     Controls.Add(C_Text);
     Controls.Add(new LiteralControl("<br>"));
     Controls.Add(C_Beschriftung);

    }

    if (EingabeErforderlich)
    {

     if (WarnungPosition == WarnungAusrichtung.rechts)
      Controls.Add(new LiteralControl("&nbsp;"));
     else
      Controls.Add(new LiteralControl("<br>"));

     RequiredFieldValidator C_Validator = new RequiredFieldValidator();
     C_Validator.ControlToValidate = "text1";
     C_Validator.Display = ValidatorDisplay.Dynamic;
     C_Validator.Text = EingabeFehltWarnung;
     Controls.Add(C_Validator);
    }

   }

   #endregion

  }

  // ### Die Design-Time Ansicht der ErweiterteTextbox - Klasse 
 public class BeschrifteteTextBox_CC3_Design : System.Web.UI.Design.ControlDesigner
  {

   public override string GetDesignTimeHtml()
   {

    Control AktuellesSteuerelement = (Control)Component;
    // --- Sicherstellung das die ChildControls bereits erstellt 
    // --- sind bevor der Render Vorgang beginnt.
    ControlCollection Steuerelemente = AktuellesSteuerelement.Controls;
    return base.GetDesignTimeHtml();

   }

  }

 } //end of root namespace