//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace WWWings.WebSteuerelemente
{

 /// <summary>
 /// Composite Control mit Render() fr Design-Time
 /// </summary>
 [DefaultProperty("Text"), ToolboxData("<{0}:BeschrifteteTextBox_DC2 runat=server></{0}:BeschrifteteTextBox_DC2>")]
 public class BeschrifteteTextBox_CC2 : System.Web.UI.WebControls.WebControl, INamingContainer
	{

		private Label C_Label = new Label();
		private TextBox C_TextBox = new TextBox();

		private string _Text;
		[Description("Der eingegebene Text des Steuerelemente"), Category("Daten"), DefaultValue("<Bitte eingeben>")]
		public string Text
		{
			get
			{
				return _Text;
			}
			set
			{
				_Text = value;
			}
		}

		private string _Label;
		public string Label
		{
			get
			{
				return _Label;
			}
			set
			{
				_Label = value;
			}
		}

		private LabelAusrichtungsArten _LabelAusrichtung;
		public LabelAusrichtungsArten LabelAusrichtung
		{
			get
			{
				return _LabelAusrichtung;
			}
			set
			{
				_LabelAusrichtung = value;
			}
		}

		public enum LabelAusrichtungsArten: int
		{
			oben,
			unten,
			rechts,
			links
		}

		protected override void CreateChildControls()
		{

			C_Label = new Label();
			C_TextBox = new TextBox();

			C_Label.Text = _Label;
			C_TextBox.Text = _Text;

		}

		protected override void RenderChildren(System.Web.UI.HtmlTextWriter writer)
		{
			if (LabelAusrichtung == LabelAusrichtungsArten.links)
			{
				Controls.Add(C_Label);
				Controls.Add(new LiteralControl("&nbsp;"));
				Controls.Add(C_TextBox);
			}
			else if (LabelAusrichtung == LabelAusrichtungsArten.rechts)
			{
				Controls.Add(C_TextBox);
				Controls.Add(new LiteralControl("&nbsp;"));
				Controls.Add(C_Label);
			}
			else if (LabelAusrichtung == LabelAusrichtungsArten.oben)
			{
				Controls.Add(C_Label);
				Controls.Add(new LiteralControl("<br>"));
				Controls.Add(C_TextBox);
			}
			else if (LabelAusrichtung == LabelAusrichtungsArten.unten)
			{
				Controls.Add(C_TextBox);
				Controls.Add(new LiteralControl("<br>"));
				Controls.Add(C_Label);
			}
			base.RenderChildren(writer);
		}

		protected override void Render(System.Web.UI.HtmlTextWriter writer)
		{
			EnsureChildControls();
			base.Render(writer);
		}

	}

} //end of root namespace