﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.Windows.Input;
namespace WWWings_WPF
{
 public partial class F_Flugbuchung
 {

  public static readonly DependencyProperty ZaehlerProperty = DependencyProperty.Register("Counter", typeof(int), typeof(F_Flugbuchung), new PropertyMetadata(0));
  public int Zaehler
  {
   get { return (int)GetValue(ZaehlerProperty); }
   set { SetValue(ZaehlerProperty, value); }
  } 


  public static RoutedCommand BeendenBefehl = new RoutedCommand();

  public F_Flugbuchung()
  {
   this.InitializeComponent();
   // Tastaturkürzel definieren
   KeyGesture Taste = new KeyGesture(Key.B, ModifierKeys.Control);

   // Befehl definieren
   BeendenBefehl.InputGestures.Add(Taste);

   // Binding definieren
   CommandBinding cb = new System.Windows.Input.CommandBinding(BeendenBefehl);
   this.CommandBindings.Add(cb);
   cb.Executed += new System.Windows.Input.ExecutedRoutedEventHandler(cb_Executed);
   cb.CanExecute += new System.Windows.Input.CanExecuteRoutedEventHandler(cb_CanExecute);

   GetData();
  }

  de.WWWings.PassagierSystem.BuchungsMenge bb;
  private void GetData()
  {

   // Datenbindung
   long PID = 0;
   if (Int64.TryParse(C_PID.Text, out PID))
   {
    // Manuelle Datenbefüllung
    de.WWWings.PassagierSystem.Passagier p = de.WWWings.Passagier_BLManager.HolePassagier(PID);
    this.C_PName.Text = p.GanzerName;
    // Datenbindung
    bb = de.WWWings.Buchung_BLManager.HoleBuchungenFuerPassagier(PID);
    this.C_Fluege.DataContext = bb;
   }
  }

  void cb_CanExecute(object sender, System.Windows.Input.CanExecuteRoutedEventArgs e)
  {
   e.CanExecute = true;
  }

  void cb_Executed(object sender, System.Windows.Input.ExecutedRoutedEventArgs e)
  {
   this.Close();
  }

  private void C_Ende_Click(object sender, RoutedEventArgs e)
  {
   this.Close();
  }

  private void C_Suchen_Click(object sender, RoutedEventArgs e)
  {

   GetData();
  }


  private void Buchung()
  {
   // Animation manuell starten
   System.Windows.Media.Animation.Storyboard sb = (Storyboard)this.FindResource("C_DrehAnimation");
   //sb.Begin(this);
   //MessageBox.Show("Diese Funktion ist leider noch nicht implementiert!");
  }

  private void C_Buchen_Click(object sender, RoutedEventArgs e)
  {
   Buchung();
  }

  private void C_Details_Click(object sender, RoutedEventArgs e)
  {
   System.ComponentModel.ICollectionView view = CollectionViewSource.GetDefaultView(bb);
   de.WWWings.PassagierSystem.Buchung b = (de.WWWings.PassagierSystem.Buchung)view.CurrentItem;
   MessageBox.Show("Buchungscode: " + b.Buchungscode.ToString());
  }

  private void C_Steuerelementhierarchie_Click(object sender, RoutedEventArgs e)
  {
   
  }

  //private string GetContent(UIElement Element)
  //{
  // foreach(UIElement e in Element.
  //}

  private void Test()
  {
   //this.C_Fluege.
  }

  private void C_Storno_Click(object sender, RoutedEventArgs e)
  {
   System.ComponentModel.ICollectionView view = CollectionViewSource.GetDefaultView(bb);
   de.WWWings.PassagierSystem.Buchung b = (de.WWWings.PassagierSystem.Buchung)view.CurrentItem;
   de.WWWings.Buchung_BLManager.BuchungenLoeschen(b.Buchungscode);
   MessageBox.Show("Flug wurde storniert: " + b.Buchungscode.ToString());
  }



 }
}