using System;
using System.Collections.Generic;
using System.Text;
using System.Messaging;
namespace de.WWWings.WCFServer
{
 class Program
 {
  static void Main(string[] args)
  {


   Print("WCF-Server wird gestartet...", ConsoleColor.Cyan);
   Print("Identitt des Server-Prozesses: " + System.Environment.UserDomainName + @"\" + System.Environment.UserName, ConsoleColor.White);
   string queueName = @".\private$\WWWings";
   MessageQueue messageQueue;
   // Create the transacted MSMQ queue if necessary.
   if (MessageQueue.Exists(queueName))
    messageQueue = new MessageQueue(queueName);
   else
    messageQueue = MessageQueue.Create(queueName);

   Print(String.Format("Es warten {0} MSMQ-Nachrichten.", messageQueue.GetAllMessages().Length),ConsoleColor.White);
   //Message lastMessage = messageQueue.Receive(new TimeSpan(0, 0, 4));
   //Console.WriteLine(lastMessage.Body.ToString());
   //Console.ReadLine();
   de.WWWings.WCFServer.WWWingsWCFServiceHost.StartService();
   Print("WCF-Server ist jetzt gestartet!", ConsoleColor.Cyan);

   SelbstTests();

   Console.ReadLine();
   Print("WCF-Server wird beendet...", ConsoleColor.Cyan);
   de.WWWings.WCFServer.WWWingsWCFServiceHost.StopService();
   Print("WCF-Server ist jetzt beendet!", ConsoleColor.Cyan);
  }

  private static void SelbstTests()
  {

   Print("Datenbank: " + System.Configuration.ConfigurationManager.ConnectionStrings["CS_WWWings"].ConnectionString,ConsoleColor.Green);
   // Interner Selbsttest (ohne Protokollstack)
   try
   {
    de.WWWings.Dienste.PingInfo p = new de.WWWings.Dienste.TestService().Ping();
    Print("Interner Selbsttest (ohne Protokollstack): OK (" + p.DBInfo.AnzFluege + "/" + p.DBInfo.AnzPassagiere + "/" + p.DBInfo.AnzBuchungen + ")", ConsoleColor.Green);
   }
   catch (Exception ex)
   {
    Print("Interner Selbsttest (ohne Protokollstack): Fehler (" + HoleFehlerText(ex) + "/" + ex.StackTrace + ")", ConsoleColor.Red);
   }

   //  Externer Selbsttest (mit Protokollstack)
   try
   {
    WWWings_WCFServer.Selbsttest.TestServiceClient tcp = new WWWings_WCFServer.Selbsttest.TestServiceClient("TestService_TCP");
    WWWings_WCFServer.Selbsttest.PingInfo p = tcp.Ping();
    Print("Externer Selbsttest (mit TCP-Protokollstack): OK (" + p.DBInfo.AnzFluege + "/" + p.DBInfo.AnzPassagiere + "/" + p.DBInfo.AnzBuchungen + ")", ConsoleColor.Green);
    tcp.Close();
   }
   catch (Exception ex)
   {
    Print("Externer Selbsttest (mit TCP-Protokollstack): Fehler (" + HoleFehlerText(ex) + "/" + ex.StackTrace + ")", ConsoleColor.Red);
   }

   //  Externer Selbsttest (mit Protokollstack)
   try
   {
    WWWings_WCFServer.Selbsttest.TestServiceClient np = new WWWings_WCFServer.Selbsttest.TestServiceClient("TestService_PIPE");
    WWWings_WCFServer.Selbsttest.PingInfo p = np.Ping();
    Print("Externer Selbsttest (mit Named Pipes): OK (" + p.DBInfo.AnzFluege + "/" + p.DBInfo.AnzPassagiere + "/" + p.DBInfo.AnzBuchungen + ")", ConsoleColor.Green);
    np.Ping();
   }
   catch (Exception ex)
   {
    Print("Externer Selbsttest (mit Named Pipes): Fehler (" + HoleFehlerText(ex) + "/" + ex.StackTrace + ")", ConsoleColor.Red);
   }
  }

  /// <summary>
  /// Hilfsmethode fr Protokollierung
  /// </summary>
  private static void Print(string Text, System.ConsoleColor Farbe)
  {
   Console.ForegroundColor = Farbe;
   Console.WriteLine(Text);
   Console.ForegroundColor = ConsoleColor.Gray;
  }

  public static string HoleFehlerText(Exception ex)
  {
   string ausgabe = ex.GetType().ToString() + ": " + ex.Message + "\n";
   if (ex.InnerException != null) ausgabe += HoleFehlerText(ex.InnerException);
   return ausgabe;
  }
 }
}
