using System;
using System.ServiceModel;

namespace de.WWWings.WCFServer
{

 class WWWingsWCFServiceHost
 {
  private long _Counter = 0;

  public long Counter
  {
   get { return _Counter; }
   set
   {
    _Counter = value;
    Console.WriteLine("Counter");
   }
  }

  static System.Collections.Generic.List<ServiceHost> WCFDienste = new System.Collections.Generic.List<ServiceHost>();

  /// <summary>
  /// Start des WCF-Servers
  /// </summary>
  public static void StartService()
  {
   NetTcpBinding binding = new NetTcpBinding();

   bool Singleton = false;

   Uri baseAddress = new Uri("net.tcp://localhost:1234/WWWings/");

   if (Singleton)
   { // Singleton
    WCFDienste.Add(new ServiceHost(new de.WWWings.Dienste.FlugplanService(), baseAddress));
    WCFDienste.Add(new ServiceHost(new de.WWWings.Dienste.FlugplanverwaltungService(), baseAddress));
    WCFDienste.Add(new ServiceHost(new de.WWWings.Dienste.BuchungsService(), baseAddress));
    WCFDienste.Add(new ServiceHost(new de.WWWings.Dienste.PassagierverwaltungService(), baseAddress));
    WCFDienste.Add(new ServiceHost(new de.WWWings.Dienste.TestService(), baseAddress));
    WCFDienste.Add(new ServiceHost(new de.WWWings.Dienste.ProtokollService(), baseAddress));
   }
   else
   { // Single-Call
    WCFDienste.Add(new ServiceHost(typeof(de.WWWings.Dienste.FlugplanService), baseAddress));
    WCFDienste.Add(new ServiceHost(typeof(de.WWWings.Dienste.FlugplanverwaltungService), baseAddress));
    WCFDienste.Add(new ServiceHost(typeof(de.WWWings.Dienste.BuchungsService), baseAddress));
    WCFDienste.Add(new ServiceHost(typeof(de.WWWings.Dienste.PassagierverwaltungService), baseAddress));
    WCFDienste.Add(new ServiceHost(typeof(de.WWWings.Dienste.TestService), baseAddress));
    WCFDienste.Add(new ServiceHost(typeof(de.WWWings.Dienste.ProtokollService), baseAddress));
   }

   // Protkollausgabe
   foreach (ServiceHost Host in WCFDienste)
   {
    Print("Starte Dienst " + Host.Description.Name, ConsoleColor.Yellow);
    foreach (System.ServiceModel.Description.ServiceEndpoint e in Host.Description.Endpoints)
    {
     Print(" - Endpunkt: " + e.Address + " (" + e.Binding.Name + ")", ConsoleColor.White);
    }
    Host.Open();
   }
  }

  /// <summary>
  /// Beenden des WCF-Servers
  /// </summary>
  internal static void StopService()
  {
   foreach (ServiceHost Host in WCFDienste)
   {
    if (Host.State != CommunicationState.Closed)
     Host.Close();
   }
  }

  /// <summary>
  /// Hilfsmethode fr Protokollierung
  /// </summary>
  private static void Print(string Text, System.ConsoleColor Farbe)
  {
   Console.ForegroundColor = Farbe;
   Console.WriteLine(Text);
   Console.ForegroundColor = ConsoleColor.Gray;
  }
 }
}

