using System;
using System.ServiceModel;

namespace de.WWWings.WCFServer
{

 // The following settings must be added to your configuration file in order for 
 // the new WCF service item added to your project to work correctly.

 // <system.serviceModel>
 //    <services>
 //      <!-- Before deployment, you should remove the returnFaults behavior configuration to avoid disclosing information in exception messages -->
 //      <service type="L3_Server.L3_Service" behaviorConfiguration="returnFaults">
 //        <endpoint contract="L3_Server.IL3_Service" binding="wsHttpBinding"/>
 //      </service>
 //    </services>
 //    <behaviors>
 //      <serviceBehaviors>
 //        <behavior name="returnFaults" >
 //          <serviceDebug includeExceptionDetailInFaults="true" />
 //        </behavior>
 //       </serviceBehaviors>
 //    </behaviors>
 // </system.serviceModel>


 // A WCF service consists of a contract (defined below), 
 // a class which implements that interface, and configuration 
 // entries that specify behaviors and endpoints associated with 
 // that implementation (see <system.serviceModel> in your application
 // configuration file).


 class EinfacherWWWingsWCFServiceHost
 {
  const bool Singleton = false;

  static ServiceHost Host;

  public static void StartService()
  {
   Uri baseAddress = new Uri("net.tcp://localhost:1234/WWWings/");
   if (Singleton)
   { // Singleton
   Host = new ServiceHost(new de.WWWings.Dienste.FlugplanService(), baseAddress);
   }
   else
   { // Single-Call
   Host = new ServiceHost(typeof(de.WWWings.Dienste.FlugplanService), baseAddress);
   }
   Host.Open();
  }

  internal static void StopService()
  {
    if (Host.State != CommunicationState.Closed)
     Host.Close();
  }
 }
}

