Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Channels.Tcp
Imports de.WWWings

Public Class RemotingHost

 Dim channel As Tcp.TcpChannel

 Public Sub StartHost()

  ' Channel erffnen
  channel = (New Tcp.TcpChannel(1234))
  ChannelServices.RegisterChannel(channel, True)

  ' "FlugBLManager" als Singleton-Objekt bereitstellen
  ' FlugBLManager ist MarshalByRefObject == ByRef
        RemotingConfiguration.RegisterWellKnownServiceType(GetType(de.WWWings.FlugBLManager), "FlugBLManager", WellKnownObjectMode.Singleton)
  ' Klasse "Flug" als CAO bereitstellen
  ' Flug ist auch MarshalByRefObject, knnte aber auch ByVal sein!
  RemotingConfiguration.ApplicationName = "Flug"
  RemotingConfiguration.RegisterActivatedServiceType(GetType(de.WWWings.Flug))

        ' Testobjekt zur bereitstellung auf dem Remoting Server
        Console.WriteLine("Selbsttest des Dienstes:")
  Dim f1 As New Flug(111, "Rom", "Berlin")
  Dim f2 As New Flug(112, "Rom", "Berlin")
  Dim f3 As New Flug(113, "Rom", "Berlin")
  Dim app As New FlugBLManager

  Console.WriteLine("Datenstze in der Datenbank: " & app.Count)

  Console.WriteLine("Datenstze im Hauptspeicher: " & app.Count_RAM)
  Console.WriteLine("OK!")
 End Sub

 Public Sub StopHost()

  ChannelServices.UnregisterChannel(channel)

 End Sub

End Class

Public Class Application

 Public Shared Function Ping() As Boolean
  Return True
 End Function

End Class
