Imports Microsoft.VisualBasic
Imports System
Imports System.Security.Cryptography.Xml
Imports System.IO
Imports System.Security
Imports System.Xml
Imports de.ITVisions.DemoViewer

Namespace NET2.FCL
 <Demo> _
 Friend Class XMLEncryption

  Private Const SCHLUESSELDATEI As String = "..\..\_Daten\XML\SCHLUESSELDATEI.txt"

  Public Sub SchluesselErzeugen()
   Dim DES As System.Security.Cryptography.TripleDESCryptoServiceProvider = New System.Security.Cryptography.TripleDESCryptoServiceProvider()
   Dim sw As StreamWriter = New StreamWriter(SCHLUESSELDATEI)
   sw.WriteLine(Convert.ToBase64String(DES.Key))
   sw.Close()
  End Sub

  Public Function HoleSchluessel() As Byte()
   Dim sr As StreamReader = New StreamReader(SCHLUESSELDATEI)
   Dim key As String = sr.ReadLine()
   sr.Close()
   Return Convert.FromBase64String(key)
  End Function

  Public Sub XMLVerschluesseln()

   Const DATEI As String = "..\..\_Daten\XML\Websites.xml"
   Const DATEI2 As String = "..\..\_Daten\XML\Websites_ver.xml"

   Demo.Print("Dokument laden...")
   Dim doc As XmlDocument = New XmlDocument()
   doc.Load(DATEI)

   For Each ele As XmlElement In doc.SelectNodes("*//Zugangsdaten")
	Demo.Print("Verschlsseln von " & ele.Name)
	Dim DES As System.Security.Cryptography.TripleDESCryptoServiceProvider = New System.Security.Cryptography.TripleDESCryptoServiceProvider()
	DES.Key = HoleSchluessel()

	Dim exml As EncryptedXml = New EncryptedXml(doc)
	Dim verdaten As Byte() = exml.EncryptData(ele, DES, False)
	Dim edata As EncryptedData = New EncryptedData()
	edata.Type = EncryptedXml.XmlEncElementUrl
	edata.EncryptionMethod = New EncryptionMethod(EncryptedXml.XmlEncTripleDESUrl)
	edata.CipherData = New CipherData()
	edata.CipherData.CipherValue = verdaten
	EncryptedXml.ReplaceElement(ele, edata, False)
   Next ele
   doc.Save(DATEI2)
  End Sub

  Public Sub XMLEntschluesseln()

   Const DATEI As String = "..\..\_Daten\XML\Websites_ver.xml"
   Const DATEI2 As String = "..\..\_Daten\XML\Websites_ent.xml"

   Demo.Print("Dokument laden...")
   Dim doc As XmlDocument = New XmlDocument()
   doc.Load(DATEI)
   Dim DES As System.Security.Cryptography.TripleDESCryptoServiceProvider = New System.Security.Cryptography.TripleDESCryptoServiceProvider()
   DES.Key = HoleSchluessel()

   Dim nm As XmlNamespaceManager = New XmlNamespaceManager(doc.NameTable)
   nm.AddNamespace("e", "http://www.w3.org/2001/04/xmlenc#")
   For Each ele As XmlElement In doc.SelectNodes("*//e:EncryptedData", nm)

	Demo.Print("Entschlsseln von " & ele.Name)
	Dim edata As EncryptedData = New EncryptedData()
	edata.LoadXml(ele)

	Dim exml As EncryptedXml = New EncryptedXml()
	Dim daten As Byte() = exml.DecryptData(edata, DES)
	exml.ReplaceData(ele, daten)
	doc.Save(DATEI2)
   Next ele

  End Sub

 End Class
End Namespace

