Imports Microsoft.VisualBasic
Imports System
Imports System.DirectoryServices
Imports ActiveDs
Imports de.ITVisions.DemoViewer

' Autor: Dr. Holger Schwichtenberg, http://www.IT-Visions.de
' Hinweis: Ersetzen Sie demo.print durch eine Ausgabefunktion ihrer Wahl oder laden Sie das Gesamtprojekt herunter unter
' http://www.IT-Visions.de/WWWings


Namespace Demos.NET2.FCL

 <Demo()> _
 Public Class Verzeichnisdienste

  Const LDAProot As String = "LDAP://xfilesserver/DC=FBI,DC=net"
  Const LDAP_USER As String = "LDAP://xfilesserver/CN=Fox Mulder,OU=Agents,DC=FBI,DC=net"
  Const LDAP_OU As String = "LDAP://xfilesserver/OU=agents,DC=FBI,DC=net"

  Sub Windows_Authentifizierung()


   Demo.Print(WindowsAuthentifizierung.IsADSIAuthentifizierbar("LDAP://xfilesserver/dc=fbi,dc=net", "fbi", "FoxMulder", "ILoveScully123").ToString())

   Demo.Print(WindowsAuthentifizierung.IsADSIAuthentifizierbar("WinNT://xfilesserver", "fbi", "FoxMulder", "ILoveScully123").ToString())

   Demo.Print(WindowsAuthentifizierung.IsWin32Authentifizierbar("E01", "ab", "123").ToString())
  End Sub



  <AutoRun()> _
  Sub ADS_Benutzer_Info()

   Dim o As DirectoryEntry
   ' --- Zugriff auf Eintrag
   o = New DirectoryEntry(LDAP_USER)
   ' --- Basis-Daten des Eintrags
   Demo.Print("Name: " & o.Name)
   Demo.Print("Pfad: " & o.Path)
   Demo.Print("Klasse:" & o.SchemaClassName)
   ' --- Ausgabe der Verzeichnisattribute
   Demo.Print("SAMAccountName: " & o.Properties("samAccountName")(0).ToString())
   Demo.Print("Description: " & getAtt(o, "Description"))
   Demo.Print("telephoneNumber: " & getAtt(o, "telephoneNumber"))
   Demo.Print("AccountExpires: " & getAtt(o, "AccountExpires"))
   Demo.Print("AccountExpires: " & GetDateTime(o, "AccountExpires"))
   Demo.Print("City: " & getAtt(o, "l"))
   ' --- Native COM-ADSI
   Demo.Print(o.NativeObject.adspath.ToString())

  End Sub

  Function getDateTime(ByVal o As DirectoryEntry, ByVal a As String) As String
   Dim li As LargeInteger = CType(o.Properties(a)(0), LargeInteger)
   If (li.HighPart = 0) AndAlso (li.LowPart = 0) Then Return "n/a"
   Dim dt_zahl As Long = ((CLng(li.HighPart) << 32) + CLng(li.LowPart))
   Dim dt As DateTime = DateTime.FromFileTime(dt_zahl)
   Return dt.ToString()
  End Function

  Sub ADS_Benutzer_Liste()

   Dim c As New DirectoryEntry(LDAP_OU)
   For Each o As DirectoryEntry In c.Children
    Demo.Print(o.SchemaClassName & ": " & o.Path.ToString())
   Next

  End Sub

  Sub ADS_Benutzer_Aendern()

   Dim o As DirectoryEntry
   ' --- Zugriff auf Eintrag
   o = New DirectoryEntry(LDAP_USER)
   ' --- Wert holen und verndern
   Dim Beschreibungstext As String = getAtt(o, "Description")
   Dim AnzahlFaelle As Long = Long.Parse(Beschreibungstext.Substring(Beschreibungstext.IndexOf(":") + 1, 2))
   AnzahlFaelle += 1
   o.Properties("Description").Item(0) = "Anzahl gelster Flle: " & AnzahlFaelle
   'o.Properties("telephoneNumber").Remove(o.Properties("telephoneNumber").Item(0))

   o.Properties("telephoneNumber").Add("001 123 123456")
   o.Properties("telephoneNumber").Add("001 11111111")
   o.Properties("otherTelephone").Add("001 11111111")
   o.Properties("otherTelephone").Add("001 22222222")
   o.Properties("otherTelephone").Add("001 33333333")

   Demo.Print("Fox Mulder hat nun " & AnzahlFaelle & " Flle gelst!")
   o.CommitChanges()

  End Sub

  Sub ADS_OU_Anlegen()
   Dim r As DirectoryEntry, ou As DirectoryEntry
   r = New DirectoryEntry(LDAProot)
   ou = r.Children.Add("ou=Directors", "organizationalUnit")
   ou.CommitChanges()
   Demo.Print("OU angelegt! " & ou.Path)
  End Sub

  Function getAtt(ByVal de As DirectoryEntry, ByVal attributname As String) As String
   Dim werteliste As PropertyValueCollection
   Dim wert As Object
   Dim ergebnis As String = ""
   werteliste = de.Properties(attributname)
   For Each wert In werteliste
    If Len(ergebnis) = 0 Then
     ergebnis = wert.ToString()
    Else
     ergebnis = ergebnis & ";" & wert.ToString()
    End If
    Return (ergebnis)
   Next
   Return ""
  End Function


  ' Anlegen eines Benutzers im Active Directory
  Public Sub ADS_Benutzer_Anlegen()
   ' AD-spezifische Parameter, bitte anpassen!
   Const LDAP_OU As String = "LDAP://xfilesserver/OU=Directors,DC=FBI,DC=net"
   Const NAME As String = "Walter Skinner"
   Const PASSWORD As String = "abc123/123"
   Const LDAP_Gruppe As String = "LDAP://xfilesserver/CN=All Directors,DC=FBI,DC=net"
   Const ORT As String = "Washington"
   Const EMAIL As String = "WSkinner@fbi.org"
   Const TEL As String = "++01 123 123456"
   ADS_Benutzer_Anlegen(LDAP_OU, NAME, PASSWORD, TEL, ORT, EMAIL, LDAP_Gruppe)
  End Sub

  Public Sub ADS_Benutzer_MassenAnlegen()
   ' AD-spezifische Parameter, bitte anpassen!
   Const LDAP_OU As String = "LDAP://xfilesserver/OU=Aliens,DC=FBI,DC=net"
   Const PASSWORD As String = "abc123/123"
   Const LDAP_Gruppe As String = "LDAP://xfilesserver/CN=All Aliens,DC=FBI,DC=net"
   Const TEL As String = "123"

   Dim start As DateTime = DateTime.Now
   For a As Long = 1 To 100
    Dim zahl As String = String.Format("{0:0000}", a)
    Dim name As String = "Alien" & zahl
    Dim email As String = "Alien" & zahl & "@universe.org"
    Dim ort As String = "Planet " & a Mod 10
    Demo.PrintHeader(name)
    ADS_Benutzer_Anlegen(LDAP_OU, name, PASSWORD, TEL, ort, email, LDAP_Gruppe)
   Next
   Dim ende As DateTime = DateTime.Now
   Demo.Print("Dauer in Sekunden: " & (ende - start).Seconds)

  End Sub


  Public Sub Test()
   Dim start As New DateTime(2005, 10, 7)
   Dim ende As New DateTime(2006, 7, 15)
   Demo.Print((ende - start).Days.ToString())
  End Sub

  ' Anlegen eines Benutzers im Active Directory
  Public Function ADS_Benutzer_Anlegen(ByVal LDAP_OU As String, ByVal Name As String, ByVal Kennwort As String, ByVal Tel As String, ByVal Ort As String, ByVal Email As String, ByVal LDAP_Gruppe As String) As DirectoryEntry
   ' AD-spezifische Parameter, bitte anpassen!

   '  Anlegen eines User-Objects im Active Directory
   Demo.Print("# Anlegen des Benutzerkontos: " & Name)

   ' Zugriff auf IADS
   Dim ou As DirectoryEntry = New DirectoryEntry(LDAP_OU)
   ' Zugriff auf IADSContainer
   Dim c As DirectoryEntries = ou.Children
   ' Neues Objekt erzeugen
   Dim u As DirectoryEntry = Nothing
   Try
    u = c.Find("cn=" & Name)
   Catch ex As Exception : End Try
   If Not u Is Nothing Then
    Demo.Print("Benutzer existiert schon und wird daher gelscht!")
    c.Remove(u)
   End If
   u = c.Add("cn=" & Name, "user")
   ' Verzeichnisattribute festlegen
   'u.Properties("sAMAccountName").Add(Name)
   u.Properties("l").Add(Ort)
   u.Properties("telephoneNumber").Add(Tel)
   u.Properties("mail").Add(Email)
   u.Properties("displayName").Add(Name)
   ' nderungen speichern
   u.CommitChanges()
   Demo.Print("Benutzer angelegt: " & u.Path.ToString())
   ' Kennwort setzen
   'u.Invoke("SetPassword", Kennwort)
   'u.NativeObject.SetPassword(Kennwort)
   CType(u.NativeObject, ActiveDs.IADsUser).SetPassword(Kennwort)
   ' Konto aktivieren

   ' Konto aktivieren
   CType(u.NativeObject, ActiveDs.IADsUser).AccountDisabled = False
   u.CommitChanges()
   Demo.Print("Benutzer aktiviert!")
   ' AD-Benutzer einer AD-Gruppe hinzufgen
   ' Zugriff auf Eintrag
   Dim g As DirectoryEntry = New DirectoryEntry(LDAP_Gruppe)
   ' IADSGroup::Add() aufrufen
   'g.Invoke("Add", u.Path.ToString())
   CType(g.NativeObject, ActiveDs.IADsGroup).Add(u.Path.ToString())
   ' Besttigung
   Demo.Print("Benutzer zu Gruppe " & g.Name & " hinzugefgt!")
   Return u
  End Function


  Sub ADS_Gruppe_Anlegen()
   Const NAME As String = "All Directors"

   Dim o As DirectoryEntry = Nothing
   Dim gr As DirectoryEntry = Nothing
   Dim c As DirectoryEntries = Nothing

   o = New DirectoryEntry(LDAProot)
   c = o.Children

   ' === Fall bercksichtigen, dass Gruppe schon da
   Try
    gr = c.Find("cn=" & NAME, "group")
   Catch ex As Exception : End Try
   If Not gr Is Nothing Then
    Demo.Print("Gruppe existiert schon und wird daher gelscht!")
    c.Remove(gr)
   End If
   ' === Gruppe anlegen
   gr = c.Add("cn=" & NAME, "group")
   gr.Properties("sAMAccountName").Add(NAME)
   gr.CommitChanges()
   Demo.Print("Gruppe angelegt! " & gr.Path)

  End Sub


  Sub ADS_Objekt_Loeschen()
   Dim o As DirectoryEntry
   o = New DirectoryEntry(LDAP_OU)
   o.DeleteTree()
   Demo.Print("Gelscht " + o.Path.ToString())
  End Sub


  ' Ausfhren einer LDAP-Suche im AD

  Public Sub LDAP_Suche()

   '   Const BEDINGUNG As String = "(&(objectclass=user)(objectcategory=person)(cn=a*))"

   Const BEDINGUNG As String = "(&(objectCategory=person)(objectClass=user)(userAccountControl:1.2.840.113556.1.4.803:=2))"


   Demo.Print("Suchanfrage im ADS")
   Demo.Print("Suche: " & BEDINGUNG & " in " & LDAProot)

   ' Instanziierung der Suchklasse
   Dim suche As DirectorySearcher = New DirectorySearcher()
   ' Festlegung des Ausgangspunkts
   suche.SearchRoot = New DirectoryEntry(LDAProot)
   ' Festlegung der LDAP-Query
   suche.Filter = BEDINGUNG
   ' Suchtiefe festlegen

   suche.SearchScope = SearchScope.Subtree
   ' Ergebnisattribute festlegen (!!! funktioniert entgegen der Dokumentation nicht!!!)
   suche.PropertiesToLoad.Add("displayName")
   suche.PropertiesToLoad.Add("l")
   suche.PropertiesToLoad.Add("description")
   suche.PropertiesToLoad.Add("samaccountname")
   ' Suche starten

   Dim ergebnisliste As SearchResultCollection = suche.FindAll()
   ' Ergebnismenge ausgeben
   Demo.Print("Anzahl Ergebnisobjekte: " & ergebnisliste.Count)
   For Each ergebnis As SearchResult In ergebnisliste
    'For Each de As System.Collections.DictionaryEntry In ergebnis.Properties
    ' Demo.Print(de.Key.ToString() & "=" & (CType(de.Value, ResultPropertyValueCollection))(0).ToString())
    'Next de

    'If ergebnis.Properties.Contains("displayName") AndAlso ergebnis.Properties.Contains("l") Then
    ' Demo.Print(ergebnis.Properties("displayName")(0).ToString() & " wohnt in " & ergebnis.Properties("l")(0).ToString())
    'Else
    ' Demo.Print(ergebnis.Properties("samaccountname")(0).ToString())
    'End If

    ' Einfacher

    Demo.Print(getSAtt(ergebnis, "samaccountname") & " wohnt in " & getSAtt(ergebnis, "l"))


   Next ergebnis
  End Sub

  Function getSAtt(ByVal se As SearchResult, ByVal attributname As String) As String
   Dim werteliste As ResultPropertyValueCollection, wert As Object = Nothing, ergebnis As String = ""
   werteliste = se.Properties(attributname)
   If se.Properties.Contains(attributname) Then
    For Each wert In werteliste
     If Len(ergebnis) = 0 Then
      ergebnis = wert.ToString()
     Else
      ergebnis = ergebnis & ";" & wert.ToString()
     End If
    Next
   End If
   Return (ergebnis)
  End Function

 End Class
End Namespace
