#Region "Using directives"


Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text

#End Region

Imports System.DirectoryServices
Imports System.DirectoryServices.ActiveDirectory
Imports de.ITVisions.DemoViewer

' Autor: Dr. Holger Schwichtenberg, http://www.IT-Visions.de
' Hinweis: Ersetzen Sie demo.print durch eine Ausgabefunktion ihrer Wahl oder laden Sie das Gesamtprojekt herunter unter
' http://www.IT-Visions.de/WWWings

Namespace Demos.NET2.FCL

 <Demo()> _
 Public Class ActiveDirectory

  Public Sub DomnenInfos()
   ' Aktuelle Domain ermitteln
   Dim d As Domain = System.DirectoryServices.ActiveDirectory.Domain.GetCurrentDomain()

   ' Informationen ber aktuelle Domne
   Demo.Print("Name: " & d.Name)
   Demo.Print("Domain Mode: " & d.DomainMode)
   Demo.Print("Inhaber der InfrastructureRole: " & d.InfrastructureRoleOwner.Name)
   Demo.Print("Inhaber der PdcRole: " & d.PdcRoleOwner.Name)
   Demo.Print("Inhaber der PdcRole: " & d.PdcRoleOwner.Name)

   ' Informationen ber Forest der aktuellen Domne
   Dim f As Forest = d.Forest
   Demo.Print("Name des Forest: " & f.Name)
   Demo.Print("Modus des Forest: " & f.ForestMode)
  End Sub


  Public Sub Schema_Klassen()
   ' Schema dieser Domne
   Dim d As Domain = System.DirectoryServices.ActiveDirectory.Domain.GetCurrentDomain()
   Dim s As ActiveDirectorySchema = ActiveDirectorySchema.GetCurrentSchema()

   ' Schema einer andere Domne
   Dim context As DirectoryContext = New DirectoryContext(DirectoryContextType.DirectoryServer, "xfilesserver")
   Dim s2 As ActiveDirectorySchema = ActiveDirectorySchema.GetSchema(context)

   Demo.PrintHeader("Inaktive Schema-Objekte:")
   Dim liste As ReadOnlyActiveDirectorySchemaClassCollection = s2.FindAllDefunctClasses()
   For Each c As ActiveDirectorySchemaClass In liste
    Demo.Print(c.CommonName)
   Next

   Dim liste2 As ReadOnlyActiveDirectorySchemaPropertyCollection = s2.FindAllDefunctProperties()
   For Each p As ActiveDirectorySchemaProperty In liste2
    Demo.Print(p.CommonName)
   Next

  End Sub

  ' Alle DC ausgeben
  Public Sub DomaenenController()
   ' Aktuelle Domain ermitteln
   Dim context As DirectoryContext = New DirectoryContext(DirectoryContextType.DirectoryServer, "192.168.1.190")
   Dim d As Domain = System.DirectoryServices.ActiveDirectory.Domain.GetDomain(context)
   Dim DCs As DomainControllerCollection = d.DomainControllers
   For Each DC As DomainController In DCs

    Demo.Print("Name: " & DC.Name)
    Demo.Print("IP: " & DC.IPAddress.ToString())
    Demo.Print("Zeit: " & DC.CurrentTime.ToString())
    Demo.Print("Rollen:")
    ' Schleife ber alle Rollen des DC
    For Each R As ActiveDirectoryRole In DC.Roles
     Demo.Print("- " & R.ToString())
    Next R
   Next DC
  End Sub
 End Class
End Namespace
