Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Security.AccessControl
Imports de.ITVisions.DemoViewer
Imports System.IO
Imports System.Security

Namespace NET2.FCL
 <Demo> _
 Friend Class Security

  ' === Ausgabe eines Secure String
  Public Sub SecureStringRueckumwandlung()
   Dim s As SecureString = New SecureString()
   s.AppendChar("g"c)
   s.AppendChar("e"c)
   s.AppendChar("h"c)
   s.AppendChar("e"c)
   s.AppendChar("i"c)
   s.AppendChar("m"c)
   s.MakeReadOnly()

   Dim p As IntPtr = System.Runtime.InteropServices.Marshal.SecureStringToBSTR(s)
   Dim KlartextKennwort As String = System.Runtime.InteropServices.Marshal.PtrToStringUni(p)
   Demo.Print(KlartextKennwort)
  End Sub

  ' === Liste der bekannten SID
  Public Sub ListeDerWellKnownSIDs()
   Demo.Print("Adminstrator: " & System.Security.Principal.WellKnownSidType.AccountAdministratorSid.ToString())
   Demo.Print("Terminal Server-Benutzer: " & System.Security.Principal.WellKnownSidType.TerminalServerSid.ToString())
   Demo.Print("Gast: " & System.Security.Principal.WellKnownSidType.AccountGuestSid.ToString())

   Demo.Print("Domnen-Administratoren: " & New System.Security.Principal.SecurityIdentifier("DA").Value)
   Demo.Print("Administrator: " & New System.Security.Principal.SecurityIdentifier("LA").Value)
   Demo.Print("Jeder: " & New System.Security.Principal.SecurityIdentifier("WD").Value)
   'Demo.Print("Adminstrator: " + new System.Security.Principal.SecurityIdentifier(System.Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, new System.Security.Principal.SecurityIdentifier(dsd,).Value);
   Demo.Print("Adminstratoren: " & New System.Security.Principal.SecurityIdentifier(System.Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, Nothing).Value)
   Demo.Print("Adminstratoren: " & New System.Security.Principal.SecurityIdentifier("BA").Value)
  End Sub

  Public Sub GetSID()
   Const BENUTZER As String = "d64\hs"

   ' Umwandlung zwischen Kontenname und SID
   Dim Name As System.Security.Principal.NTAccount = New System.Security.Principal.NTAccount(BENUTZER)
   Dim SID As System.Security.Principal.SecurityIdentifier = CType(Name.Translate(GetType(System.Security.Principal.SecurityIdentifier)), System.Security.Principal.SecurityIdentifier)

   ' Umwandlung zwischen SID und Kontenname
   Demo.Print("Name: " & Name.Value & " = SID " & SID.Value)

   Name = CType(SID.Translate(GetType(System.Security.Principal.NTAccount)), System.Security.Principal.NTAccount)
   Demo.Print("SID: " & SID.Value & " = Name " & Name.Value)
  End Sub


  ' Hinzufgen von ACEs
  Public Sub SDErgaenzen()
   Const DATEI As String = "c:\HolgerSchwichtenberg.doc"

   ' Hole ACL
   Dim objFS As FileSecurity = File.GetAccessControl(DATEI)

   ' ACE erzeugen
   Dim rule As FileSystemAccessRule = New FileSystemAccessRule(New System.Security.Principal.NTAccount("d64\hs"), FileSystemRights.Modify, AccessControlType.Allow)

   Dim rule2 As FileSystemAccessRule = New FileSystemAccessRule(New System.Security.Principal.SecurityIdentifier(System.Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, Nothing), FileSystemRights.FullControl, AccessControlType.Allow)

   ' Regel hinzufgen
   objFS.AddAccessRule(rule)
   objFS.AddAccessRule(rule2)

   ' Speichern
   File.SetAccessControl(DATEI, objFS)
  End Sub


  ' Auslesen einer Datei-ACL
  Public Sub SDAuslesen()
   Const DATEI As String = "c:\HolgerSchwichtenberg.doc"

   ' Hole ACL
   Dim objFS As FileSecurity = File.GetAccessControl(DATEI)

   ' Besitzer
   Demo.Print("Besitzer SID: " & objFS.GetOwner(GetType(System.Security.Principal.SecurityIdentifier)).Value)
   Demo.Print("Besitzer Name: " & objFS.GetOwner(GetType(System.Security.Principal.NTAccount)).Value)

   ' Hole einzelne ACEs aus ACL
   Dim ACEs As AuthorizationRuleCollection = objFS.GetAccessRules(True, True, GetType(System.Security.Principal.NTAccount))

   ' Schleife ber alle ACEs
   For Each ACE As FileSystemAccessRule In ACEs
	If ACE.AccessControlType = AccessControlType.Allow Then
		If ACE.IsInherited Then
			Console.WriteLine("Benutzer/Gruppe {0}: {1} {2} ({3})", ACE.IdentityReference.ToString(), ACE.FileSystemRights,"zugelassen","vererbt")
		Else
			Console.WriteLine("Benutzer/Gruppe {0}: {1} {2} ({3})", ACE.IdentityReference.ToString(), ACE.FileSystemRights,"zugelassen","explizit")
		End If
	Else
		If ACE.IsInherited Then
			Console.WriteLine("Benutzer/Gruppe {0}: {1} {2} ({3})", ACE.IdentityReference.ToString(), ACE.FileSystemRights,"verweigert","vererbt")
		Else
			Console.WriteLine("Benutzer/Gruppe {0}: {1} {2} ({3})", ACE.IdentityReference.ToString(), ACE.FileSystemRights,"verweigert","explizit")
		End If
	End If
   Next ACE
  End Sub
 End Class
End Namespace

