Imports Microsoft.VisualBasic
Imports System
Imports System.Diagnostics
Imports de.ITVisions.DemoViewer

Namespace NET2.FCL

 <Demo> _
 Public Class Prozesse


  ' Liste aller laufenden Prozesse

  Public Sub Prozesse_Liste()

   ' Liste der Prozesse holen
   Dim pp As Process() = Process.GetProcesses()

   ' Schleife ber alle Prozesse
   For Each p As Process In pp
	Demo.Print("------------------------")
	Demo.Print(p.Id & ":" & p.ProcessName)
	Demo.Print("------------------------")
	If p.Id <> 0 Then
	 Demo.Print("Handle Count           :" & p.HandleCount.ToString())
	 Demo.Print("Main Window Title      :" & p.MainWindowTitle)
	 Demo.Print("Min Working Set        :" & p.MinWorkingSet.ToString())
	 Demo.Print("Max Working Set        :" & p.MaxWorkingSet.ToString())
	 Demo.Print("Paged Memory Size      :" & p.PagedMemorySize64.ToString())
	 Demo.Print("Peak Paged Memory Size :" & p.PeakPagedMemorySize64.ToString())
	End If

   Next p
  End Sub

  ' Liste aller Instanzen von Microsoft Word
  Public Sub Prozesse_AuflistenSelektiv()
   ' Liste ausgewhlter Prozesse
   Dim processName As String = "winword"
   ' Liste der Prozesse holen
   Dim pp As Process() = Process.GetProcessesByName(processName)
   ' Ausgaben
   Demo.Print("Prozesse mit Namen: " & processName)
   Demo.Print("Anzahl von Prozessen: " & pp.Length)
   ' Schleife ber alle Instanzen
   For Each p As Process In pp
	Demo.Print(p.Id & ":" & p.StartTime)
   Next p
  End Sub

  Public Sub Prozesse_ThreadListe()

   ' Liste aller Prozesse mit ihren Threads
   ' Liste der Prozesse holen
   Dim pp As Process() = Process.GetProcesses()

   ' Schleife ber alle Prozesse
   For Each p As Process In pp
	Demo.Print("------------------------")
	Demo.Print(p.Id & ":" & p.ProcessName)
	Demo.Print("------------------------")
	If p.Id <> 0 Then
	 ' Schleife ber alle Threads
	 Demo.Print("Anzahl Threads: " & p.Threads.Count)
	 For Each t As ProcessThread In p.Threads
	  Demo.Print("- " & t.Id & ":" & t.ThreadState & ":" & t.StartTime)
	 Next t
	End If
   Next p
  End Sub

  Public Sub Prozesse_ModulListe()

   ' Liste aller Prozesse mit ihren Modulen
   ' Liste der Prozesse holen
   Dim pp As Process() = Process.GetProcesses()

   ' Schleife ber alle Prozesse
   For Each p As Process In pp

	Demo.Print("------------------------")
	Demo.Print(p.Id & ":" & p.ProcessName)
	Demo.Print("------------------------")

	If p.Id <> 0 Then
	 Demo.Print("Anzahl Module: " & p.Modules.Count)

	 If Not p.MainModule Is Nothing Then
	  Demo.Print("Hauptmodul: " & p.MainModule.ModuleName)
	 End If

	 ' Schleife ber alle Module
	 For Each m As ProcessModule In p.Modules
	  Demo.Print("- " & m.ModuleName & ":" & m.FileName & ":" & m.ModuleMemorySize)
	 Next m
	End If
   Next p
  End Sub


  ' Start eines Prozesses
  Public Sub Prozess_Starten()
   Process.Start("IExplore.exe", "http://www.dotnetframework.de")
  End Sub




  ' Alle Internet Explorer-Prozesse stoppen
  Public Sub Prozess_Stoppen()
   Dim processName As String = "winword"
   ' Prozesse dieses Namens ermitteln
   Dim pp As Process() = Process.GetProcessesByName(processName)
   ' Schleife ber diese Prozesse
   Demo.Print("Beenden aller Prozesse mit Namen: " & processName)
   Demo.Print("Anzahl Prozesse: " & pp.Length)
   For Each p As Process In pp
	Demo.Print("Prozess: " & p.Id & " wird beendet...")
	' Beenden Anfrage stellen...
	If p.CloseMainWindow() Then
	 ' Normales Ende
	 Demo.Print("  Prozess wurde normal beendet!")
	Else
	 ' Keine Reaktion -> gewaltsames Ende
	 p.Kill()
	 Demo.Print("  Prozess wurde gewaltsam beendet!")
	End If
   Next p
  End Sub

  Public Sub Prozesse_ohne_Reaktion_stoppen()

   ' Alle hngenden Prozesse stoppen

   ' Prozesse ermitteln
   Dim pp As Process() = Process.GetProcesses()

   ' Schleife ber diese Prozesse
   Demo.Print("Beenden aller nicht-reagierenden Prozesse")

   For Each p As Process In pp
	If (Not p.Responding) Then
	 Demo.Print("Prozess hngt " & p.ProcessName & " und wird beendet...")
	 ' Keine Reaktion -> gewaltsames Ende
	 p.Kill()
	 Demo.Print("  Prozess wurde gewaltsam beendet!")
	End If
   Next p
  End Sub
 End Class
End Namespace
