#Region "Using directives"


Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text

#End Region
Imports System.Net.NetworkInformation
Imports System.Net
Imports System.Threading
Imports de.ITVisions.DemoViewer
Imports System.IO

Namespace NET2.FCL
 <de.ITVisions.DemoViewer.Demo> _
 Public Class Netzwerk

  '[Demo("Herunterladen einer Datei per FTP")]
  Public Sub FTPDownload()
   Const URL As String = "ftp://bochum/Flugdaten.xml"
   Const LOKALERPFAD As String = "c:\temp\Flugdaten_download.xml"
   Dim ftp As FtpWebRequest = CType(FtpWebRequest.Create(URL), FtpWebRequest)
   ftp.Method = WebRequestMethods.Ftp.DownloadFile
   ftp.Credentials = New NetworkCredential("xx", "xxx")
   Dim response As FtpWebResponse = CType(ftp.GetResponse(), FtpWebResponse)
   Dim responseStream As Stream = response.GetResponseStream()
   Demo.Print("Lade Datei...")
   Dim fileStream As FileStream = Nothing

   ' ffnen der Zieldatei
   fileStream = File.Create(LOKALERPFAD)
   Dim buffer As Byte() = New Byte(1023){}
   Dim bytesRead As Integer
   ' Einlesen und in Datei kopieren
   Do While True
	bytesRead = responseStream.Read(buffer, 0, buffer.Length)
	If bytesRead = 0 Then
	 Exit Do
	End If
	fileStream.Write(buffer, 0, bytesRead)
	Console.Write(".")
   Loop
   ' Alles schliessen!
   responseStream.Close()
   fileStream.Close()
   Demo.Print("Fertig!")
  End Sub

  '[Demo("Heraufladen einer Datei per FTP")]
  <FCL2> _
  Public Sub FTPUpload()
   Const URL As String = "ftp://bochum/Flugdaten.xml"
   Const LOKALERPFAD As String = "c:\temp\Flugdaten.xml"

   ' --- Request erstellen
   Dim ftp As FtpWebRequest = CType(WebRequest.Create(URL), FtpWebRequest)
   ftp.Method = WebRequestMethods.Ftp.UploadFile
   ftp.Credentials = New NetworkCredential("xx", "xxx")
   ftp.Timeout = System.Threading.Timeout.Infinite
   Dim requestStream As Stream = ftp.GetRequestStream()
   Demo.Print("Sende Datei...")
   ' --- Kopieren des Inhalts aus der Datei
   Const bufferLength As Integer = 2048
   Dim buffer As Byte() = New Byte(bufferLength - 1){}
   Dim count As Integer = 0
   Dim readBytes As Integer = 0
   ' ffnen der Quelldatei
   Dim fileStream As FileStream = File.OpenRead(LOKALERPFAD)
   ' Einlesen der Quelldatei
   Do
	readBytes = fileStream.Read(buffer, 0, bufferLength)
	requestStream.Write(buffer, 0, bufferLength)
	count += readBytes
	Console.Write(".")
   Loop While readBytes <> 0
   ' --- Antworten holen
   requestStream.Close()
   Dim response As FtpWebResponse = CType(ftp.GetResponse(), FtpWebResponse)
   Demo.Print("Fertig!")
   response.Close()
   fileStream.Close()
  End Sub

  '[Demo("Inhalt eines FTP-Verzeichnisses auflisten")]
  <FCL2> _
  Public Sub FTPInhaltAuflisten()
   Const URL As String = "ftp://bochum/"
   Dim reader As StreamReader = Nothing
   Dim ftp As FtpWebRequest = CType(WebRequest.Create(URL), FtpWebRequest)
   ftp.Credentials = New NetworkCredential("ar", "hs")
   ftp.Method = WebRequestMethods.Ftp.ListDirectoryDetails
   Dim Response As FtpWebResponse = CType(ftp.GetResponse(), FtpWebResponse)
   reader = New StreamReader(Response.GetResponseStream())
   Demo.Print(reader.ReadToEnd())
   Demo.Print("Fertig!")
   reader.Close()
  End Sub


  ' Ping ausfhren
  Public Sub Ping()
   Const COMPUTER As String = "www.IT-Visions.de"
   Dim p As Ping = New Ping()
   ' Ping synchron ausfhren
   Demo.PrintHeader("Synchroner Ping")
   Dim pr As PingReply = p.Send(COMPUTER)
   Demo.Print(pr.Status & ";" & pr.RoundtripTime)
   ' Ping asynchron ausfhren
   Demo.PrintHeader("Asynchroner Ping")
   AddHandler p.PingCompleted, AddressOf p_PingCompleted
   p.SendAsync(COMPUTER, Nothing)

  End Sub
  ' Callsback fr Ping
  Private Shared Sub p_PingCompleted(ByVal sender As Object, ByVal e As PingCompletedEventArgs)
   Demo.Print(e.Reply.Status & ";" & e.Reply.RoundtripTime & "ms")
  End Sub

  Public Sub NetStatus()
   Dim adapters As NetworkInterface() = NetworkInterface.GetAllNetworkInterfaces()
   For Each n As NetworkInterface In adapters
	Demo.Print("Netzwerkstatus:  {0} = {1}", n.Name, n.OperationalStatus)
   Next n
  End Sub
  Public Sub NetStatusWarten()
   NetStatus()
   AddHandler NetworkChange.NetworkAvailabilityChanged, AddressOf NetworkChange_NetworkAvailabilityChanged
   Demo.Print("berwachung...")
   Console.ReadLine()
  End Sub

  Private Sub NetworkChange_NetworkAvailabilityChanged(ByVal sender As Object, ByVal e As NetworkAvailabilityEventArgs)
   NetStatus()
  End Sub


  ' Statistische Daten aus dem TCP/IP-Protokollstack
  Public Sub NetStatistik()
   Dim ipgp As IPGlobalProperties = IPGlobalProperties.GetIPGlobalProperties()
   Dim t As TcpStatistics = ipgp.GetTcpIPv4Statistics()
   Demo.Print("CurrentConnections: " & t.CurrentConnections.ToString())
   Demo.Print("ErrorsReceived: " & t.ErrorsReceived.ToString())
   Demo.Print("MaximumConnections: " & t.MaximumConnections.ToString())
   Demo.Print("SegmentsReceived: " & t.SegmentsReceived.ToString())
   Demo.Print("SegmentsSent: " & t.SegmentsSent.ToString())
  End Sub

  ' Absenden einer HTTP-Anfrage
  Public Sub HTTP_Anfrage()
   Const URL As String = "http://www.it-visions.de"
   ' Anfrage definieren
   Dim frage As HttpWebRequest = CType(HttpWebRequest.Create(URL), HttpWebRequest)
   ' Antwort holen
   Dim antwort As HttpWebResponse = CType(frage.GetResponse(), HttpWebResponse)
   ' Meta-Daten
   Demo.Print("Antwortlnge: " & antwort.ContentLength)
   Demo.Print("Status: " & antwort.StatusCode)
   Demo.Print("Letzte nderung: " & antwort.LastModified)
   Demo.Print("Inhaltstyp: " & antwort.ContentType)
   ' Inhalt ausgeben
   Dim sr As StreamReader = New StreamReader(antwort.GetResponseStream())
   Demo.Print(sr.ReadToEnd())
  End Sub

  ' FTP Download
  Public Shared Function DisplayFileFromServer() As Boolean

   Dim serverUri As Uri = New Uri("ftp://bochum")
   ' The serverUri parameter should start with the ftp:// scheme.
   If serverUri.Scheme <> Uri.UriSchemeFtp Then
	Return False
   End If
   ' Get the object used to communicate with the server.
   Dim request As WebClient = New WebClient()

   ' This example assumes the FTP site uses anonymous logon.
   request.Credentials = New NetworkCredential("xy", "xy")
   Try
	Dim newFileData As Byte() = request.DownloadData(serverUri.ToString())
	Dim fileString As String = System.Text.Encoding.UTF8.GetString(newFileData)
	Demo.Print(fileString)
   Catch e As WebException
	Demo.Print(e.ToString())
   End Try
   Return True
  End Function

 End Class


 Public Class FtpState
  Private wait As ManualResetEvent
  Private request_Renamed As FtpWebRequest
  Private fileName_Renamed As String
  Private operationException_Renamed As Exception = Nothing
  Private status As String

  Public Sub New()
   wait = New ManualResetEvent(False)
  End Sub

  Public ReadOnly Property OperationComplete() As ManualResetEvent
   Get
	   Return wait
   End Get
  End Property

  Public Property Request() As FtpWebRequest
   Get
	   Return request_Renamed
   End Get
   Set
	   request_Renamed = Value
   End Set
  End Property

  Public Property FileName() As String
   Get
	   Return fileName_Renamed
   End Get
   Set
	   fileName_Renamed = Value
   End Set
  End Property
  Public Property OperationException() As Exception
   Get
	   Return operationException_Renamed
   End Get
   Set
	   operationException_Renamed = Value
   End Set
  End Property
  Public Property StatusDescription() As String
   Get
	   Return status
   End Get
   Set
	   status = Value
   End Set
  End Property
 End Class

 <Demo> _
 Public Class AsynchronousFtpUpLoader
  ' Command line arguments are two strings:
  ' 1. The url that is the name of the file being uploaded to the server.
  ' 2. The name of the file on the local machine.
  '
  Public Sub Start()
   ' Create a Uri instance with the specified URI string.
   ' If the URI is not correctly formed, the Uri constructor
   ' will throw an exception.
   Dim waitObject As ManualResetEvent

   Dim target As Uri = New Uri("ftp://ff44.s6.domainkunden.de/~db/extranet.mdb")
   Dim fileName As String = "M:\ITVWEB\~db\extranet.mdb"
   Dim state As FtpState = New FtpState()
   Dim request As FtpWebRequest = CType(WebRequest.Create(target), FtpWebRequest)
   'request.Method = FtpMethods.UploadFile;

   ' This example uses anonymous logon.
   ' The request is anonymous by default; the credential does not have to be specified. 
   ' The example specifies the credential only to
   ' control how actions are logged on the server.

   request.Credentials = New NetworkCredential("FF44", "xb3472868")

   ' Store the request in the object that we pass into the
   ' asynchronous operations.
   state.Request = request
   state.FileName = fileName

   ' Get the event to wait on.
   waitObject = state.OperationComplete

   ' Asynchronously get the stream for the file contents.
   request.BeginGetRequestStream(New AsyncCallback(AddressOf EndGetStreamCallback), state)

   ' Block the current thread until all operations are complete.
   waitObject.WaitOne()

   ' The operations either completed or threw an exception.
   If Not state.OperationException Is Nothing Then
	Throw state.OperationException
   Else
	Demo.Print("The operation completed - {0}", state.StatusDescription)
   End If
  End Sub
  Private Shared Sub EndGetStreamCallback(ByVal ar As IAsyncResult)
   Dim state As FtpState = CType(ar.AsyncState, FtpState)

   Dim requestStream As Stream = Nothing
   ' End the asynchronous call to get the request stream.
   Try
	requestStream = state.Request.EndGetRequestStream(ar)
	' Copy the file contents to the request stream.
	Const bufferLength As Integer = 2048
	Dim buffer As Byte() = New Byte(bufferLength - 1){}
	Dim count As Integer = 0
	Dim readBytes As Integer = 0
	Dim stream As FileStream = File.OpenRead(state.FileName)
	Do
	 readBytes = stream.Read(buffer, 0, bufferLength)
	 requestStream.Write(buffer, 0, bufferLength)
	 count += readBytes
	Loop While readBytes <> 0
	Demo.Print("Writing {0} bytes to the stream.", count)
	' IMPORTANT: Close the request stream before sending the request.
	requestStream.Close()
	' Asynchronously get the response to the upload request.
	state.Request.BeginGetResponse(New AsyncCallback(AddressOf EndGetResponseCallback), state)
   ' Return exceptions to the main application thread.
   Catch e As Exception
	Demo.Print("Could not get the request stream.")
	state.OperationException = e
	state.OperationComplete.Set()
	Return
   End Try

  End Sub

  ' The EndGetResponseCallback method  
  ' completes a call to BeginGetResponse.
  Private Shared Sub EndGetResponseCallback(ByVal ar As IAsyncResult)
   Dim state As FtpState = CType(ar.AsyncState, FtpState)
   Dim response As FtpWebResponse = Nothing
   Try
	response = CType(state.Request.EndGetResponse(ar), FtpWebResponse)
	response.Close()
	state.StatusDescription = response.StatusDescription
	' Signal the main application thread that 
	' the operation is complete.
	state.OperationComplete.Set()
   ' Return exceptions to the main application thread.
   Catch e As Exception
	Demo.Print("Error getting response.")
	state.OperationException = e
	state.OperationComplete.Set()
   End Try
  End Sub
 End Class
End Namespace



