Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Configuration
Imports de.ITVisions.DemoViewer

Namespace NET2.FCL
  <Demo> _
  Friend Class ConfigurationDemos

	' Lesen aller Inhalte der Sektionen <appSettings> und <connectionStrings>
	Public Sub Config_LesenAlle()
	  Demo.PrintHeader("Liste aller Anwendungseinstellungen:")
	  ' --- Liste aller Anwendungseinstellungen
	  For Each aset As String In ConfigurationManager.AppSettings

		Demo.Print(aset & " = " & ConfigurationManager.AppSettings(aset))
	  Next aset

	  Demo.PrintHeader("Liste aller Verbindungszeichenfolgen:")
	  ' --- Liste aller Verbindungszeichenfolgen
	  For Each cset As ConnectionStringSettings In ConfigurationManager.ConnectionStrings
		Demo.Print(cset.Name & " = " & cset.ConnectionString)
	  Next cset
	End Sub

	Public Sub Config_LesenEinzelne()
	  Demo.PrintHeader("Einzelne Einstellungen:")
	  Dim MailServer As String = ConfigurationManager.AppSettings("Mailserver")
	  Dim WWWSQLDatenbank As String = ConfigurationManager.ConnectionStrings("WWWDatenbank_MSSQL").ConnectionString
	  Dim WWWAccessDatenbank As String = ConfigurationManager.ConnectionStrings("WWWDatenbank_Access").ConnectionString
	  Demo.Print("Mailserver: " & MailServer)
	  Demo.Print("Verbindungszeichenfolge 1: " & WWWSQLDatenbank)
	  Demo.Print("Verbindungszeichenfolge 2: " & WWWAccessDatenbank)
	End Sub

	' Auflisten aller Sektion der Anwendungskonfigurationsdatei
	Public Sub Anwendungskonfig_Lesen()
	  ' --- Zugriff auf machine.config
	  Dim mc As Configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None)
	  Demo.Print("Datei liegt hier: " & mc.FilePath)
	  Demo.Print("Computerebene?: " & mc.EvaluationContext.IsMachineLevel)
   Demo.Print("HostingContext?: " & mc.EvaluationContext.HostingContext.ToString())
	  ' --- Liste der Sektionen in der machine.config
	  For Each s As ConfigurationSection In mc.Sections
		Demo.Print("Sektion: " & s.SectionInformation.Name)
		Demo.Print("   Schreibschutz?: " & s.SectionInformation.IsLocked)
		Demo.Print("   Verschlsselt?: " & s.SectionInformation.IsProtected)
	  Next s
	End Sub


	' Auflisten aller Sektion der maschine.config
	Public Sub MaschineConfig_Lesen()
	  ' --- Zugriff auf machine.config
	  Dim mc As Configuration = ConfigurationManager.OpenMachineConfiguration()
	  Demo.Print("machine.config liegt hier: " & mc.FilePath)
	  Demo.Print("Computerebene?: " & mc.EvaluationContext.IsMachineLevel)
   Demo.Print("HostingContext?: " & mc.EvaluationContext.HostingContext.ToString())
	  ' --- Liste der Sektionen in der machine.config
	  For Each s As ConfigurationSection In mc.Sections

		Demo.Print("Sektion: " & s.SectionInformation.Name)
		Demo.Print("   Schreibschutz?: " & s.SectionInformation.IsLocked)
		Demo.Print("   Verschlsselt?: " & s.SectionInformation.IsProtected)
	  Next s
	End Sub

	' Verndern einer Anwendungskonfigurationsdatei
	Public Sub Config_Schreiben()
	  ' --- ndern einer Einstellung
	  Dim c As Configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None)
	  Dim aset As ConfigurationSection = c.GetSection("appSettings")
	  ConfigurationManager.AppSettings("Mailserver") = "Bochum"
	  c.Save(ConfigurationSaveMode.Full)
	  Demo.Print("Mailserver nun: " & ConfigurationManager.AppSettings("Mailserver"))
	End Sub

	Public Sub Config_Verschlueseln()

	  Demo.Print("Zugriff auf Sektion...")
	  Dim c As Configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None)
	  Dim s As ConfigurationSection = c.GetSection("connectionStrings")

	  Demo.Print("   Name: " & s.SectionInformation.Name)
	  Demo.Print("   Verschlsselt?: " & s.SectionInformation.IsProtected)
	  If (Not s.SectionInformation.IsProtected) Then
		Demo.Print("Verschlsseln...")
		s.SectionInformation.ProtectSection(ProtectedConfiguration.DataProtectionProviderName)
	  Else
		Demo.Print("Entschlsseln...")
		s.SectionInformation.UnprotectSection()

	  End If
	  c.Save()
	  Demo.Print("Kontrolle...")
	  Dim c2 As Configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None)
	  Dim s2 As ConfigurationSection = c2.GetSection("connectionStrings")
	  Demo.Print("   Name: " & s2.SectionInformation.Name)
	  Demo.Print("   Verschlsselt?: " & s2.SectionInformation.IsProtected)
	  Demo.Print("Nutzen...")
	  Dim WWWAccessDatenbank As String = ConfigurationManager.ConnectionStrings("WWWDatenbank_MSSQL").ConnectionString
	  Demo.Print("Verbindungszeichenfolge: " & WWWAccessDatenbank)
	  Demo.Print("Fertig! :-)")
	End Sub

	'public void SettingsDemos()
	'{

	'  NET2.Properties.Settings s = new NET2.Properties.Settings();
	'  s.AnzahlAufrufDiesesBenutzers++;
	'  //s.AnzahlProgrammAufrufe++;
	'  s.Save();


	'  Demo.Print("Anzahl Programmaufrufe aller Nutzers: " + s.AnzahlProgrammAufrufe.ToString());
	'  Demo.Print("Anzahl Programmaufrufe dieses Nutzer: " + s.AnzahlAufrufDiesesBenutzers.ToString());

	'  Demo.Print("Hier liegt die benutzerspezifische Konfigurationsdatei: " + System.Windows.Forms.Application.LocalUserAppDataPath);
	'}
  End Class
End Namespace
