#Region "Using directives"

Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports de.ITVisions.DemoViewer
#End Region


' .NET Framework 2.0 Demos
' (C) Dr. Holger Schwichtenberg
' http://www.dotnetframework.de
' =====================================

#Region "Regelwerk"

'The SqlNotificationRequest/SqlDependency's SELECT statement must follow the rules for statements that can be used in SQL Server Indexed Views. This is because the NotificationRequest architecture uses the same mechanism as indexed views to deduce when a row in a resultset has changed. Here are  the rules for indexed views:
'
' The select list cannot use the * or table_name.* syntax to specify columns.  
' Column names must be explicitly stated. 
' Table names must be qualified with two part names. No 3 or 4 part names can be used. 
' A table column name used as a simple expression cannot be specified more than once. 
' No derived tables. 
' No rowset functions. 
' No UNION operator. 
' No subqueries. 
' No outer or self joins. 
' No TOP clause.  
' No DISTINCT keyword. 
' No COUNT(*) aggregate. 
' No AVG, MAX, MIN, STDEV, STDEVP, VAR, or VARP aggregates 
' No User Defined Aggregates 
' No SUM function that references a nullable expression 
' No full-text predicates that CONTAINS or FREETEXT. 
' No COMPUTE or COMPUTE BY clause 
' If GROUP BY is not specified, the select list cannot contain aggregate expressions 
' If GROUP BY is specified, the select list must contain a COUNT_BIG(*) expression, and cannot specify HAVING, CUBE, or ROLLUP 
' Must not reference table variables 
' Must not reference any other views or inlineable table-valued functions. 
' Must not reference any system tables or views 
' Must not reference any non-deterministic function  including ranking/windowing functions 
' Must not references any system session (@@) variables  
' Must reference some base table or view 
' No INTO clause 
' Must not specify FOR BROWSE (or be running with SET NO_BROWSETABLE ON) 
' No conditions that will preclude results from changing (e.g. WHERE 1=0) 
' Can not specify READPAST locking hint.  
' Must not reference any Service Broker QUEUE 
'
'  
#End Region

Namespace NET2.ADONET
 <Demo()> _
 Public Class Notifications_Demos

#Region "Eigenstndiges Beispiel"
  Private Shared dep As SqlDependency = Nothing, dep2 As SqlDependency = Nothing

  Private Shared DataChanged As Boolean = False

  ' === Warten auf Datennderungen in der Flug-Tabelle
  Public Sub run()
   Console.WriteLine("berwachung der Flugliste [Query Notifications]")

   Dim CONNSTRING As String = System.Configuration.ConfigurationManager.ConnectionStrings("WorldWideWings").ConnectionString

   Const SQL As String = "Select FL_FlugNr,Fl_Abflugort, FL_Zielort, Fl_Plaetze, Fl_FreiePlaetze from dbo.FL_Fluege where FL_zielort = 'Berlin'"

   ' Verbindung aufbauen

   Do While True
    DataChanged = False
    ' Befehl definieren
    Dim cmd As SqlCommand = GetDep(CONNSTRING, SQL)

    Console.WriteLine("SQLDependency definiert fr " & SQL)
    ' Ereignisbehandlung binden
    AddHandler dep.OnChange, AddressOf dep_OnChange

    ' Befehl ausfhren
    Console.WriteLine("Aktuelle Daten werden eingelesen...")
    Dim r As SqlDataReader = cmd.ExecuteReader()
    Demo.PrintReader(r)
    cmd = Nothing

    ' Warten!!
    Do While Not DataChanged
     System.Threading.Thread.Sleep(1000)
     Console.Write(".")
    Loop
   Loop

   'TODO: SqlDependency.Stop(connectionstring);
  End Sub

  Private Shared Function GetDep(ByVal CONNSTRING As String, ByVal SQL As String) As SqlCommand
   SqlDependency.Start(CONNSTRING) ' Neu. Erst kurz vor RTM! siehe
   Dim conn As SqlConnection = New SqlConnection(CONNSTRING)
   conn.Open()
   Dim cmd As SqlCommand = New SqlCommand(SQL, conn)
   dep = New SqlDependency(cmd)
   Console.WriteLine("DEP-ID: " & dep.Id)
   Return cmd
  End Function

#End Region

  ' Ereignisbehandlung fr genderte Daten
  Private Shared Sub dep_OnChange(ByVal sender As Object, ByVal e As SqlNotificationEventArgs)
   If e.Type = SqlNotificationType.Subscribe Then
    Console.WriteLine("Fehler: " & e.Info.ToString())
   Else
    Console.BackgroundColor = ConsoleColor.Cyan
    Console.WriteLine(Constants.vbLf & "Daten haben sich gendert!")
    Console.BackgroundColor = ConsoleColor.Black
    Console.WriteLine("Typ: " & e.Type.ToString())
    Console.WriteLine("Quelle: " & e.Source.ToString())
    Console.WriteLine("Info: " & e.Info.ToString())
    DataChanged = True
   End If
  End Sub


  '#region Test der WWWings DAL
  'de.WWWings.DAL.Flug_DataManager2 FDM = new de.WWWings.DAL.Flug_DataManager2();

  'public void run2()
  '{
  ' Console.WriteLine("berwachung der Flugliste [Query Notifications]");
  ' FDM.AktualisierungenMelden("Berlin");
  ' FDM.FluegeWurdenAktualisiert += new de.WWWings.DAL.Flug_DataManager2.FluegeWurdenAktualisiertHandler(FDM_FluegeWurdenAktualisiert);
  ' Console.ReadLine();
  '}

  'void FDM_FluegeWurdenAktualisiert()
  '{
  ' Console.WriteLine("UPDATE!");
  '}
  '#endregion
 End Class

End Namespace