' .NET Framework 2.0 Demos
' (C) Dr. Holger Schwichtenberg
' http://www.dotnetframework.de
' =====================================

Imports Microsoft.VisualBasic
Imports System
Imports System.Data.SqlClient
Imports System.Data.Sql
Imports System.Data
Imports de.ITVisions.DemoViewer
Imports de.WWWings.MiscDemos
Namespace NET2.ADONET

 <Demo> _
 Public Class AsyncCommand

  Private CONNSTRING As String = DemoConfig.CONNSTRING

  ' Asynchrone Befehlsausfhrung mit Callback
  Public Sub run_Callback()
   Demo.PrintHeader("Asynchrone Ausfhrung - Callback-Modell")
   Const SQL As String = "Select * from Fl_Fluege"

   Dim sqlConn As SqlConnection = New SqlConnection(CONNSTRING)
   sqlConn.Open()
   Dim sqlCmd As SqlCommand = sqlConn.CreateCommand()
   sqlCmd.CommandText = SQL

   Dim callback As AsyncCallback = New AsyncCallback(AddressOf CallbackHandler)
   sqlCmd.BeginExecuteReader(callback, sqlCmd, CommandBehavior.CloseConnection)
   '   sqlCmd.Cancel(); Beta 1: Not supported
   For a As Integer = 0 To 10000
	Demo.Print(a.ToString())
	System.Windows.Forms.Application.DoEvents()
   Next a
  End Sub

  'sqlCmd.Cancel();

  Private Shared Sub CallbackHandler(ByVal result As IAsyncResult)
   Demo.PrintHeader("Callback von asynchronem Reader-Aufruf...")
   Dim command As SqlCommand = CType(result.AsyncState, SqlCommand)
   Dim reader As SqlDataReader = command.EndExecuteReader(result)

   Demo.Print("Hat der Befehl Zeilen geliefert? " & reader.HasRows)
   ' Ausgabe der Ergebnisse
   PrintReader(reader)
  End Sub

  ' Asynchrone Befehlsausfhrung via Polling
  Public Sub run_Polling()
   Demo.PrintHeader("Asynchrone Ausfhrung - Polling")
   Const SQL As String = "Select *from FL_Fluege"
   ' Verbindung aufbauen
   Dim sqlConn As SqlConnection = New SqlConnection(CONNSTRING)
   sqlConn.Open()
   ' Befehl definieren
   Dim sqlCmd As SqlCommand = sqlConn.CreateCommand()
   sqlCmd.CommandText = SQL
   ' Befehl starten
   Dim result As IAsyncResult = sqlCmd.BeginExecuteReader(CommandBehavior.CloseConnection)
   ' Warten...
   Demo.Print("Befehl abgesendet, jetzt warte ich...")
   Do While Not result.IsCompleted
    Demo.Print("Polling...")
   Loop
   ' Ergebnis auswerten
   Dim reader As SqlDataReader = sqlCmd.EndExecuteReader(result)
   Demo.Print("Daten (Polling):")
   PrintReader(reader)
  End Sub

  ' Asynchrone Befehlsausfhrung via WaitHandler
  Public Sub run_Warten()
   Demo.PrintHeader("Asynchrone Ausfhrung - Wartemodell")
   Const SQL As String = "Select * from FL_Fluege"
   ' Verbindung aufbauen
   Dim sqlConn As SqlConnection = New SqlConnection(CONNSTRING)
   sqlConn.Open()
   ' Befehl definieren
   Dim sqlCmd As SqlCommand = sqlConn.CreateCommand()
   sqlCmd.CommandText = SQL
   ' Befehl starten
   Dim result As IAsyncResult = sqlCmd.BeginExecuteReader(CommandBehavior.CloseConnection)
   ' Warten...
   Demo.Print("Befehl abgesendet, jetzt warte ich...")
   result.AsyncWaitHandle.WaitOne()
   ' Ergebnis auswerten
   Dim reader As SqlDataReader = sqlCmd.EndExecuteReader(result)
   Demo.Print("Daten (Wartemodell):")
   PrintReader(reader)
  End Sub

  Public Shared Sub PrintReader(ByVal reader As IDataReader)
   Do While reader.Read()
	Dim i As Integer = 0
	Do While i < reader.FieldCount
     Demo.Print("Spalte: " & reader.GetName(i) + Constants.vbTab & " = " & reader.GetValue(i).ToString())

		i += 1
	Loop
   Loop
  End Sub

 End Class
End Namespace
