Imports System.Runtime.Serialization.Formatters.Binary
Imports System.Xml.Serialization
Imports System.IO


Public Module EinfacheSerialisierung


 ' === Beispiel fr  Serialisieren
 Sub Serialisieren_Test()
  ' --- Objekt erzeugen und fllen

  Dim a As New Autor()

  a.Name = "Holger Schwichtenberg"
  a.Geb = #8/1/1972#
  a.Geschlecht = "m"
  a.Schwerpunkte = New String() {"Scripting", "COM", ".NET"}

  ' --- Serialisierungsziele
  Const DATEI = "..\_daten\Serial\Autor.bin"
  Const DATEISOAP = "..\_daten\Serial\Autor.soap.xml"
  Const DATEIXML = "..\_daten\Serial\Autor.xml"

  ' --- binre Serialisieren
  out("-- Binre Serialisierung...")
  save(SerialTyp.BINARY, a, DATEI)
  a = load(SerialTyp.BINARY, DATEI)
  out(a.Name & " wurde am " & a.Geb & " geboren!")

  ' --- binre Serialisieren
  out("-- Binre Serialisierung...")
  save(SerialTyp.SOAP, a, DATEISOAP)
  a = load(SerialTyp.SOAP, DATEISOAP)
  out(a.Name & " wurde am " & a.Geb & " geboren!")

  ' --- XML Serialisieren
  out("-- XML Serialisierung...")
  save(SerialTyp.XML, a, DATEIXML)
  a = load(SerialTyp.XML, DATEIXML, a.GetType)
  out(a.Name & " wurde am " & a.Geb & " geboren!")


 End Sub

 ' === Beispiel fr  Serialisieren
 Sub Deserialisieren_Test()

  ' --- Objektvariable bereitstellen
  Dim a1, a2, a3 As Autor

  ' --- Serialisierungsziele
  Const DATEI = "..\_daten\Serial\Autor.bin"
  Const DATEISOAP = "..\_daten\Serial\Autor.soap.xml"
  Const DATEIXML = "..\_daten\Serial\Autor.xml"

  ' --- binre Serialisieren
  out("-- Binre Deserialisierung...")
  a1 = load(SerialTyp.BINARY, DATEI)
  out(a1.Name & " wurde am " & a1.Geb & " geboren!")

  ' --- binre Serialisieren
  out("-- Binre Deserialisierung...")
  a2 = load(SerialTyp.SOAP, DATEISOAP)
  out(a2.Name & " wurde am " & a2.Geb & " geboren!")

  ' --- XML Serialisieren
  out("-- XML Deserialisierung...")
  a3 = load(SerialTyp.XML, DATEIXML, a3.GetType)
  out(a3.Name & " wurde am " & a3.Geb & " geboren!")

 End Sub

 ' === Beispiel fr binres Serialisieren
 Sub bin_Serialisieren_Test()
  ' --- Objekt erzeugen und fllen
  Dim a As New Autor()
  a.Name = "Schwichtenberg"
  a.Geb = #8/1/1972#
  a.Geschlecht = "m"

  a.Schwerpunkte = New String() {"Scripting", "COM", ".NET"}

  ' --- Serialisierungsziel
  Const DATEI = "..\_daten\Serial\Autor.xml"

  ' --- binre Serialisieren
  save(SerialTyp.BINARY, a, DATEI)
  a = load(SerialTyp.BINARY, DATEI)

  ' --- Ausgabe des Objekts zum Test
  out(a.Name & " wurde am " & a.Geb & " geboren!")
 End Sub


 ' === Beispiel fr XML-Serialisieren
 Sub XML_Serialisieren_Test()
  ' --- Objekt erzeugen und fllen
  Dim a As New Autor()
  a.Name = "Holger Schwichtenberg"
  a.Geb = #8/1/1972#
  a.Geschlecht = "m"

  a.Schwerpunkte = New String() {"Scripting", "COM", ".NET"}

  ' --- Serialisierungsziel
  Const DATEI = "..\_daten\Serial\Autor.xml"

  ' --- binre Serialisieren
  save(SerialTyp.XML, a, DATEI)
  a = load(SerialTyp.XML, DATEI, GetType(Autor))

  ' --- Ausgabe des Objekts zum Test
  out(a.Name & " wurde am " & a.Geb & " geboren!")
 End Sub





End Module

Public Module Samples_SerialisierenFCL

 <Serializable()> Class gemischteKlasse
  Public n As System.Xml.XmlNode
  Public ds As New System.Data.DataSet()

 End Class


 Sub BCL_serial()

  Dim g As New gemischteKlasse()

  Const CONNSTRING As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=..\_daten\adonet\EDVShoa.mdb;"
  Const sql = "SELECT * FROM Produkte WHERE kategorie=23"

  ' --- DataSet fllen
  Dim DA As System.Data.OleDb.OleDbDataAdapter
  DA = New System.Data.OleDb.OleDbDataAdapter(sql, CONNSTRING)
  DA.Fill(g.ds, "EDV-Antik")

  ' XMLDoc fllen
  Dim doc As New System.Xml.XmlDocument()
  doc.Load("..\_daten\xml\hs.xml")
  g.n = doc.SelectSingleNode("*//Buecherliste")

  save(SerialTyp.XML, g, "..\_daten\xml\misc.xml")



 End Sub

 ' --- Serialisieren in XML (in Speicher)
 Sub xia4()
  Const DATEI = "d:\test.xml"

  ' --- Objekt erzeugen und fllen
  Dim a As New Autor()
  a.Name = "Holger Schwichtenberg"
  a.Geb = #8/1/1972#
  a.Geschlecht = "m"


  save(SerialTyp.XML, a, DATEI)

  Dim ms As New MemoryStream()
  ' --- Serialisieren in MemoryStream
  Dim serializer As New XmlSerializer(a.GetType)
  serializer.Serialize(ms, a)
  out("Objekt wurde serialisiert!")

  out("-- Inhalt des Streams:")
  ' --- Stream ausgeben
  Dim r As StreamReader = New StreamReader(ms)
  ' --- Zeiger auf den Anfang
  r.BaseStream.Seek(0, SeekOrigin.Begin)
  ' --- Alle Zeilen lesen und an Console ausgeben
  While r.Peek() > -1
   out(r.ReadLine())
  End While
  'r.Close()

  ' --- Datei-Stram
  Dim fs As New FileStream(DATEI, IO.FileMode.Truncate)
  fs.Write(ms.ToArray, 0, ms.Length)
  fs.Close()
  out("Objekt wurde gespeichert in " & DATEI)

  ms.Close()

  Dim p2 As Autor
  p2 = load(SerialTyp.XML, DATEI, GetType(Autor))

  ' --- Ausgabe des Objekts zum Test
  out(p2.Name & " wurde am " & p2.Geb & " geboren!")

 End Sub


End Module
