Imports System.Data.OleDb
Imports System.IO
Imports System.Xml.Serialization
Imports System.Runtime.Serialization

Module Samples_Serialisieren_Datenbank

  Public Const CONNSTR As String = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=..\_DATEN\adonet\lieferanten.mdb;"


  ' === Objektpersistenz in Datenbank
  Sub DB_Persistenz1()

    outtitle("Objekt in Datenbank persistent machen")

    ' --- Objektdefinition
  Dim p As New Autor()
    a.Vorname = "Holger2"
    a.Name = "Schwichtenberg"
    a.Geb = #8/1/1972#
    a.Geschlecht = "m"
    a.Kinderanzahl = 0
    a.Taetigkeiten = New String() {"Berater", "Entwickler", "Journalist", "Dozent"}

    ' --- Serialisieren in XML-String
    Dim s As String
    s = save(SerialTyp.XML,p)

    ' --- Serialisieren in binre Bytefolge
    Dim ba As Byte()
  ba = save(SerialTyp.bin, (p))

    Dim DS As System.Data.DataSet
    Dim DT As System.Data.DataTable
    Dim DR As System.Data.DataRow
    Dim DA As System.Data.OleDb.OleDbDataAdapter
    Dim CB As System.Data.OleDb.OleDbCommandBuilder

    ' --- DataSet erzeugen
    DS = New System.Data.DataSet()
    ' --- Adapter definieren
    Const SQL As String = _
"SELECT * FROM Personen where ID = 0"
    DA = New OleDbDataAdapter(SQL, CONNSTR)
    ' --- SQL-DML-Befehle erzeugen
    CB = New OleDbCommandBuilder(DA)

    out("INSERT-Befehl: " & _
CB.GetInsertCommand.CommandText())
    ' --- Tabelle einlesen
    DA.Fill(DS, "Personen")

    ' --- Zugriff auf Tabelle
    DT = DS.Tables("Personen")

    ' --- ANFGEN EINES DATENSATZES
    DR = DT.NewRow()
    ' Fllen der Spalten
    DR("Name") = a.Name
    DR("Vorname") = a.Vorname
    DR("BIN") = ba
    DR("XML") = s
    ' Anfgen der Zeile
    DT.Rows.Add(DR)
    '  Speichern der nderungen
    DA.Update(DS, "Personen")
    DS.Dispose()

    out("Objekt wurde in Datenbank gespeichert!")
  End Sub

  ' === Persistente .NET-Objekte aus Datenbank auslesen
  Sub DB_Persistenz2()

    outtitle("Persistentes Objekte aus Datenbank lesen")
  Dim p As Autor

    Dim DS As System.Data.DataSet
    Dim DT As System.Data.DataTable
    Dim DR As System.Data.DataRow
    Dim DA As System.Data.OleDb.OleDbDataAdapter

    Const SQL As String = "SELECT * FROM Personen"
    ' --- DataSet erzeugen
    DS = New System.Data.DataSet()
    ' --- Adapter definieren
    DA = New OleDbDataAdapter(SQL, CONNSTR)
    ' --- Tabelle einlesen
    DA.Fill(DS, "Personen")
    ' --- Zugriff auf Tabelle
    DT = DS.Tables("Personen")

    ' --- Zeilenweise auslesen
    For Each DR In DT.Rows
      Dim ba As Byte()
      Dim s As String
      ' --- Binr serialiertes Objekt einlesen
      ba = DR("Bin")
      p = load(SerialTyp.Binary,ba)
      out(a.Vorname & " " & a.Name & " wurde am " & a.Geb & " geboren!")
      ' --- XML-Serialisiertes Objekt einlesen
      s = DR("XML")
      p = xml_deserialize_string(a.GetType, s)
      out(a.Vorname & " " & a.Name & " wurde am " & a.Geb & " geboren!")
    Next

    DS.Dispose()

  End Sub
End Module
