using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.Serialization.Formatters.Soap;
using System.Xml.Serialization;
using System.IO;
using System;
using de.ITVisions.DemoViewer;
using System.Windows.Forms;
using System.Runtime.Serialization;
using System.Xml;
using System.Collections.Generic;
namespace VerschiedeneDemos_CS.FCL3
{

 public enum SerialTyp : int
 {
  SOAP,
  XML,
  BINARY,
  DATACONTRACT,
  NETDATACONTRACT
 }

 internal sealed class Serialisieren_Hilfsroutinen
 {

  // ### Serialisieren in Datei
  public static void save(SerialTyp Typ, object obj, string datei)
  {
   // Datei ffnen
   FileStream stream = null;
   stream = new FileStream(datei, FileMode.Create, FileAccess.Write, FileShare.None);
   // Fallunterscheidung
   object Serializer = null;
   switch (Typ)
   {
    case SerialTyp.BINARY:
     Serializer = new BinaryFormatter();
     // Serialisierung starten
     ((BinaryFormatter)Serializer).Serialize(stream, obj);
     break;
    case SerialTyp.SOAP:
     Serializer = new SoapFormatter();
     // Serialisierung starten
     ((SoapFormatter)Serializer).Serialize(stream, obj);
     break;
    case SerialTyp.XML:
     Serializer = new XmlSerializer(obj.GetType());
     // Serialisierung starten
     ((XmlSerializer)Serializer).Serialize(stream, obj);
     break;
    case SerialTyp.DATACONTRACT:
     List<Type> knownTypeList = new List<Type>();
     knownTypeList.Add(typeof(Buch));
     knownTypeList.Add(typeof(Autor));
     knownTypeList.Add(typeof(Auflage));
     knownTypeList.Add(typeof(Verlag));
     knownTypeList.Add(typeof(Buchautor));
     XmlDictionaryWriter writer = XmlDictionaryWriter.CreateBinaryWriter(stream);
     DataContractSerializer ser = new DataContractSerializer(obj.GetType(), knownTypeList,100,false,true,null);

      ser.WriteObject(writer, obj);
      writer.Close();
     break;

    case SerialTyp.NETDATACONTRACT:
     XmlDictionaryWriter writer2 = XmlDictionaryWriter.CreateTextWriter(stream);
     NetDataContractSerializer ser2 = new NetDataContractSerializer();
     ser2.WriteObject(writer2, obj);
     writer2.Close();
     break;
    default:
     MessageBox.Show("Nicht untersttztes Serialiserungsformat!");
     System.Environment.Exit(1);
     break;
   }

   // Datei schlieen
   stream.Close();
   // Ausgabe
   Demo.Print("Objekt wurde gespeichert in " + datei);
  }

  // ### Deserialisieren aus Datei

  public static object load(SerialTyp typ, string Datei)
  {
   return load(typ, Datei, null);
  }

  //INSTANT C# NOTE: C# does not support optional parameters. Overloaded method(s) are created above.
  //ORIGINAL LINE: Function load(ByVal typ As SerialTyp, ByVal Datei As String, Optional ByVal Objekttyp As Type = null) As Object
  public static object load(SerialTyp typ, string Datei, Type Objekttyp)
  {
   // Datei ffnen
   FileStream stream = null;
   stream = new FileStream(Datei, FileMode.Open);
   // Fallunterscheidung
   object Serializer = null;
   // Ergebnis
   object o = null;

   switch (typ)
   {
    case SerialTyp.BINARY:
     Serializer = new BinaryFormatter();
     o = ((BinaryFormatter)Serializer).Deserialize(stream);
     break;
    case SerialTyp.SOAP:
     Serializer = new SoapFormatter();
     o = ((SoapFormatter)Serializer).Deserialize(stream);
     break;
    case SerialTyp.XML:
     if (Objekttyp == null)
     {
      MessageBox.Show("Fehler: Fr den XML-Deserialisierer muss der zu deserialisierende Objekttyp bekannt sein!");
      System.Environment.Exit(1);
     }
     Serializer = new XmlSerializer(Objekttyp);
     o = ((XmlSerializer)Serializer).Deserialize(stream);
     break;

    case SerialTyp.DATACONTRACT:

     List<Type> knownTypeList = new List<Type>();
     knownTypeList.Add(typeof(Buch));
     knownTypeList.Add(typeof(Autor));
     knownTypeList.Add(typeof(Auflage));
     knownTypeList.Add(typeof(Verlag));
     knownTypeList.Add(typeof(Buchautor));

     XmlDictionaryReader reader =
        XmlDictionaryReader.CreateBinaryReader(stream, new XmlDictionaryReaderQuotas());
     DataContractSerializer ser2 = new DataContractSerializer(Objekttyp, knownTypeList);
     o = ser2.ReadObject(reader, true);
      break;

     case SerialTyp.NETDATACONTRACT:

      XmlDictionaryReader reader2 =
         XmlDictionaryReader.CreateTextReader(stream, new XmlDictionaryReaderQuotas());
      NetDataContractSerializer ser = new NetDataContractSerializer();
      o = ser.ReadObject(reader2, true);
      break;

    default:
     MessageBox.Show("Nicht untersttztes Serialiserungsformat!");
     System.Environment.Exit(1);
     break;
   }


   // Datei schliessen
   stream.Close();
   // Ausgabe
   Demo.Print("Objekt wurde geladen aus " + Datei);
   // Objekt zurckliefern
   return o;
  }






  // ### Serialisieren in Bytfolge
  //Function save(SerialTyp.bin,(ByVal o As Object) As Byte()
  // Dim form As New BinaryFormatter()
  // Dim stream As New MemoryStream()
  // form.Serialize(stream, o)
  // stream.Close()
  // out("Objekt serialisiert!")
  // Return (stream.ToArray)
  //End Function

  //' ### Deserialisieren aus einer Binrdatei
  //Function load(SerialTyp.Binary,ByVal Datei As String) As Object
  // Dim o As Object
  // Dim form As New BinaryFormatter()
  // Dim stream As FileStream
  // stream = New FileStream(Datei, FileMode.Open)
  // o = form.Deserialize(stream)
  // stream.Close()
  // out("Objekt wurde geladen aus " & Datei)
  // Return o
  //End Function

  //' ### Deserialisieren aus einer Bytefolge
  //Function load(SerialTyp.Binary,ByVal ba As Byte()) As Object
  // Dim o As Object
  // Dim form As New BinaryFormatter()
  // Dim stream As New MemoryStream(ba)
  // o = form.Deserialize(stream)
  // stream.Close()
  // out("Objekt wurde deserialisiert")
  // Return o
  //End Function


  //' ### SOAP-Deserialisieren aus einer Binrdatei
  //Function load(SerialTyp.soap,ByVal Datei As String) As Object
  // Dim o As Object
  // Dim form As New SoapFormatter()
  // Dim stream As FileStream
  // stream = New FileStream(Datei, FileMode.Open)
  // o = form.Deserialize(stream)
  // stream.Close()
  // out("Objekt wurde geladen aus " & Datei)
  // Return o
  //End Function


  //' ### Deserialisieren aus XML-Datei
  //Function load(ByVal t As Type, ByVal datei As String) As Object
  // Dim obj As Object
  // Dim reader As New StreamReader(datei)
  // Dim serializer As New XmlSerializer(t)
  // obj = serializer.Deserialize(reader)
  // out("Objekt wurde geladen aus " & datei)
  // reader.Close()
  // Return (obj)
  //End Function

  //' ### XML-Serialisieren in String
  public static string xml_deserialize_string(object obj)
  {
   XmlSerializer serializer = new XmlSerializer(obj.GetType());
   string s = null;

   // --- Serialisieren in MemoryStream
   MemoryStream ms = new MemoryStream();
   serializer.Serialize(ms, obj);
   Demo.Print("Objekt wurde serialisiert!");

   // --- Stream in String umwandeln   
   StreamReader r = new StreamReader(ms);
   r.BaseStream.Seek(0, SeekOrigin.Begin);
   s = r.ReadToEnd();

   // Alternative:
   //Dim b As Byte
   //Dim ba As Byte()
   //ba = ms.ToArray
   //For Each b In ba
   //  s = s & Convert.ToChar(b)
   //Next

   return s;
  }

  // ### Zeichenweise Umwandlung eines Memory-Streams in einen String
  public static string ms_to_string(MemoryStream ms)
  {
   string s = null;
   //INSTANT C# NOTE: Commented this declaration since looping variables in 'foreach' loops are declared in the 'foreach' header in C#
   //  byte b = 0;
   byte[] ba = null;
   ba = ms.ToArray();
   foreach (byte b in ba)
   {
    s = s + (char)(b);
   }
   return s;
  }

  // ### Deserialisieren aus XML-String
  public static object xml_deserialize_string(Type t, string s)
  {
   object obj = null;
   // --- Objekt in Stream kopieren
   MemoryStream stream = new MemoryStream();
   StreamWriter w = new StreamWriter(stream);
   w.BaseStream.Seek(0, SeekOrigin.End);
   w.WriteLine(s);
   w.Close();
   // Stream umkopieren, weil jetzt geschlossen
   stream = new MemoryStream(stream.ToArray());
   XmlSerializer serializer = new XmlSerializer(t);
   obj = serializer.Deserialize(stream);
   Demo.Print("Objekt wurde deserialisiert!");
   stream.Close();
   return (obj);
  }
 }

}
