using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;
using System.Collections;

namespace VerschiedeneDemos_CS.FCL3
{

 using System.Xml.Serialization;

 //' === Klassendefinition fr einfache Serialisierung-Beispiele
 //<Serializable()> Public Class Autor
 // Public Name As String
 // Public Vorname As String
 // Public Geb As Date
 // Public Geschlecht As Char
 // Public Kinderanzahl As Byte
 // Public Schwerpunkte As String()
 // Private Gehalt As Double

 // Sub New()
 //  out("Kontruktor von Autor aufgerufen...")
 // End Sub

 //End Class


 // =======================================

 [Serializable()]
 public class Autor
 {
  public string Name;
  public char Geschlecht;
  private System.DateTime _Geb;
  public string[] Schwerpunkte;


  public DateTime Geb
  {
   set
   {
    Demo.Print("Geb setzen...");
    _Geb = value;
   }
   get
   {
    Demo.Print("Geb lesen...");
    return _Geb;
   }
  }

  public Autor()
  {
   Demo.Print("Parameterloser Kontruktor der Klasse 'Autor' aufgerufen...");
  }

  public Autor(string Name)
  {
   Name = Name;
   Demo.Print("Kontruktor der Klasse 'Autor' aufgerufen...");
  }


  //[OnSerializing()]
  //internal void OnSerializingMethod(StreamingContext context)
  //{
  // Demo.Print("This value went into the data file during serialization.");
  //}

  //[OnSerialized()]
  //internal void OnSerializedMethod(StreamingContext context)
  //{
  // Demo.Print("This value was reset after serialization.");
  //}

  //[OnDeserializing()]
  //internal void OnDeserializingMethod(StreamingContext context)
  //{
  // Demo.Print("This value was set during deserialization");
  //}

  //[OnDeserialized()]
  //internal void OnDeserializedMethod(StreamingContext context)
  //{
  // Demo.Print("This value was set after deserialization.");
  //}

 }


 // =======================================

 [Serializable(), XmlInclude(typeof(Auflage))]
 public class Buch
 {
  public string Titel;
  public Autor Autor;
  public ArrayList Auflagen = new ArrayList();
  [NonSerialized()]
  public System.DateTime Deserialisiert;
  public Verlag Verlag;

  public Buch()
  {

  }
  public Buch(string Titel)
  {
   this.Titel = Titel;
  }

 }

 // =======================================

 [Serializable(), XmlInclude(typeof(Buch))]
 public class Buchautor : Autor
 {
  public ArrayList buecher = new ArrayList();

  public Buchautor(string Name)
  {
   this.Name = Name;
   Demo.Print("Kontruktor der Klasse 'Buchautor' aufgerufen...");
  }

  public Buchautor()
  {
   Demo.Print("Parameterloser Kontruktor der Klasse 'Buchautor' aufgerufen...");
  }

 }

 // =======================================

 //<Serializable(), XmlInclude(GetType(Buch)), XmlRoot("BAutor")> Public Class Buchautor
 // Inherits Autor
 // <XmlElement("GeschriebeneBuecher")> Public buecher As New ArrayList()
 // <XmlIgnore()> Public Gehalt As Single
 // <XmlAttributeAttribute()> Public Aktiv As Boolean = True

 // Sub New(ByVal Name As String)
 //  Name = Name
 //  out("Kontruktor der Klasse 'Buchautor' aufgerufen...")
 // End Sub

 // Sub New()
 //  out("Parameterloser Kontruktor der Klasse 'Buchautor' aufgerufen...")
 // End Sub

 //End Class

 // =======================================

 [Serializable(), XmlInclude(typeof(Buch))]
 public class Verlag
 {
  public string Name;
  public string Ort;
  public ArrayList Buecher = new ArrayList();

  public Verlag()
  {
  }

  public Verlag(string Verlagsname)
  {
   Name = Verlagsname;
  }
 }

 // =======================================

 [Serializable()]
 public class Auflage
 {
  public byte Nr;
  public int Jahr;
  public string ISBn;

  public Auflage()
  {
  }

  public Auflage(byte Nr, int Jahr, string ISBN)
  {
   this.Nr = Nr;
   this.Jahr = Jahr;
   this.ISBn = ISBN;
  }
 }






}
