using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;
using System.Runtime.InteropServices;

namespace VerschiedeneDemos_CS.Interop
{

 [Demo]
 class PInvoke
 {

  // Use DllImportAttribute to inport the Win32 MessageBox
  // function.  Set the SetLastError flag to true to allow
  // the function to set the Win32 error.
  [DllImportAttribute("user32.dll", SetLastError = true)]
  public static extern int MessageBox(IntPtr hwnd, String text, String caption, uint type);


  public void GetLastWin32Error_Run()
  {
   // Call the MessageBox with normal parameters.

   Console.WriteLine("Calling Win32 MessageBox without error...");

   PInvoke.MessageBox(new IntPtr(0), "Press OK...", "Press OK Dialog", 0);

   // Get the last error and display it.
   int error = Marshal.GetLastWin32Error();

   Demo.Print("The last Win32 Error was: " + error);

   // Call the MessageBox with an invalid window handle to
   // produce a Win32 error.

   Demo.Print("Calling Win32 MessageBox with error...");

   PInvoke.MessageBox(new IntPtr(123132), "Press OK...", "Press OK Dialog", 0);

   // Get the last error and display it.

   error = Marshal.GetLastWin32Error();

   Demo.Print("The last Win32 Error was: " + error);
  }

 }
}
