using System;
using System.Security.Cryptography.Xml;
using System.IO;
using System.Security;
using System.Xml;
using de.ITVisions.DemoViewer;

namespace NET2.FCL
{
 [Demo]
 class XMLEncryption
 {

  const string SCHLUESSELDATEI = @"..\..\_Daten\XML\SCHLUESSELDATEI.txt";
 
  public void SchluesselErzeugen()
  {
   System.Security.Cryptography.TripleDESCryptoServiceProvider DES = new System.Security.Cryptography.TripleDESCryptoServiceProvider();
   StreamWriter sw = new StreamWriter(SCHLUESSELDATEI);
   sw.WriteLine(Convert.ToBase64String(DES.Key));
   sw.Close();
  }

  public byte[] HoleSchluessel()
  {
   StreamReader sr = new StreamReader(SCHLUESSELDATEI);
   string key = sr.ReadLine();
   sr.Close();
   return Convert.FromBase64String(key);
  }

  public void XMLVerschluesseln()
  {

   const string DATEI = @"..\..\_Daten\XML\Websites.xml";
   const string DATEI2 = @"..\..\_Daten\XML\Websites_ver.xml";

   Demo.Print("Dokument laden...");
   XmlDocument doc = new XmlDocument();
   doc.Load(DATEI);

   foreach (XmlElement ele in doc.SelectNodes(@"*//Zugangsdaten"))
   {
    Demo.Print("Verschlsseln von " + ele.Name);
    System.Security.Cryptography.TripleDESCryptoServiceProvider DES = new System.Security.Cryptography.TripleDESCryptoServiceProvider();
    DES.Key = HoleSchluessel();

    EncryptedXml exml = new EncryptedXml(doc);
    Byte[] verdaten = exml.EncryptData(ele, DES, false);
    EncryptedData edata = new EncryptedData();
    edata.Type = EncryptedXml.XmlEncElementUrl;
    edata.EncryptionMethod = new EncryptionMethod(EncryptedXml.XmlEncTripleDESUrl);
    edata.CipherData = new CipherData();
    edata.CipherData.CipherValue = verdaten;
    EncryptedXml.ReplaceElement(ele, edata, false);
   }
   doc.Save(DATEI2);
  }

  public void XMLEntschluesseln()
  {

   const string DATEI = @"..\..\_Daten\XML\Websites_ver.xml";
   const string DATEI2 = @"..\..\_Daten\XML\Websites_ent.xml";

   Demo.Print("Dokument laden...");
   XmlDocument doc = new XmlDocument();
   doc.Load(DATEI);
   System.Security.Cryptography.TripleDESCryptoServiceProvider DES = new System.Security.Cryptography.TripleDESCryptoServiceProvider();
   DES.Key = HoleSchluessel();

   XmlNamespaceManager nm = new XmlNamespaceManager(doc.NameTable);
   nm.AddNamespace("e", "http://www.w3.org/2001/04/xmlenc#");
   foreach (XmlElement ele in doc.SelectNodes("*//e:EncryptedData", nm))
   {

    Demo.Print("Entschlsseln von " + ele.Name);
    EncryptedData edata = new EncryptedData();
    edata.LoadXml(ele);

    EncryptedXml exml = new EncryptedXml();
    Byte[] daten = exml.DecryptData(edata, DES);
    exml.ReplaceData(ele, daten);
    doc.Save(DATEI2);
   }

  }

 }
}

