// Demo for TechEd 2004
// Author: Dr. Holger Schwichtenberg
// http://www.IT-Visions.de

// These samples are attributed for NUnit-Testing!

using System;
using System.Management;
using de.ITVisions.DemoViewer;


namespace de.ITVisions.TechEd04.Samples
{

	[Demo] 
	public class Misc
	{
		public Misc()
		{
			//AllDrives2();
			//GetInfoAboutDiskC();
			//CreateJob();
			
		}

		// Get info about one drive

		public void GetInfoAboutDiskC() 
		{

			// Path to local C: Drive 
			string Path = @"\root\cimv2:Win32_Logicaldisk.DeviceID='C:'";

			// Bind to the WMI Object
			ManagementObject mo = new ManagementObject(Path);

			// Attributs of the meta object
			PrintHeader("Meta data:");
			Print("Full path:" + mo.Path.Path);
			Print("Relative path:" + mo.Path.RelativePath);
			Print("Computer: " + mo.Path.Server);
			Print("Namespace:" + mo.Path.NamespacePath);
			Print("Standard path: " + ManagementPath.DefaultPath.Path);
			Print("Class name: " + mo.Path.ClassName);

			// Attributs of the WMI object
			PrintHeader("Data of the Managed Object");
			Print("Name: " + mo["Caption"]);
			Print("File system type: " + mo["FileSystem"]);
			Print("Free Bytes: " + Convert.ToUInt64(mo["FreeSpace"]).ToString());
		}

		// List all drives

		public void AllDrives() 
		{
			// Bind to the class definition
			ManagementClass mc = new ManagementClass("Win32_Logicaldisk");
			// Get all instances
			ManagementObjectCollection menge = mc.GetInstances();
			// Enumerate the instances
			foreach (ManagementObject mo in menge)
			{
				Print(mo["Name"].ToString() + " has " + Convert.ToUInt64(mo["FreeSpace"]).ToString() + " free Bytes");
			}
		}

		// Change all Drives

		public void AllDrives2() 
		{
			string abfrage = "SELECT * FROM Win32_Logicaldisk";
			string namensraum = @"\root\cimv2";
			ManagementObjectSearcher search = new ManagementObjectSearcher(namensraum, abfrage, null);

			ManagementObjectCollection col = search.Get();
    
			foreach (ManagementObject mo in col)
			{
				Print(mo["VolumeName"].ToString() + " has " + Convert.ToUInt64(mo["FreeSpace"]).ToString() + " free Bytes");
				mo.SetPropertyValue("VolumeName","test" + mo["VolumeName"].ToString());
				mo.Put();
			}
		}

		// Restrict access to the terminal service

		public void SetTSMaxConnections()
		{
			// Path Terminal Server Adapter
			string Path = @"//.\root\cimv2:Win32_TSNetworkAdapterSetting.TerminalName='RDP-Tcp'";

			// Bind to the WMI Object
			ManagementObject mo = new ManagementObject(Path);
		
			// Set property
			mo.SetPropertyValue("MaximumConnections",2);
		
			// Persist changes
			mo.Put();
		}

		// Set DNS servers

		public void SetDNSServers()
		{
			// Path to network adapter
			string Path = @"//.\root\cimv2:Win32_NetworkAdapterConfiguration.index=1";

			// Bind to the WMI Object
			ManagementObject mo = new ManagementObject(Path);
		
			// Set property
			string[] DNSServerList = { "192.168.123.50", "192.168.123.254" };
			//mo.SetDNSServerSearchOrder(DNSServerList);
		}

		// Install software

		public void InstallSoftware()
		{
			// Path to network adapter
			string Path = @"//.\root\cimv2:Win32_Product";

			string InstallPath = @"C:\_Install\_Dev\NUnit\Nunit-V2.1.4.msi";
			// Bind to the WMI Object
			ManagementClass mo = new ManagementClass(Path);
		
			// construct array of parameters
			object[] parameters = { InstallPath,"",true};
			// Call the method
			mo.InvokeMethod("Install",parameters);
		}


		// Call CheckDisk on Demo.Print
		public void CallCheckDisk() 
		{

			// Bind to the MO
			ManagementObject mo = new ManagementObject(@"//.\root\cimv2:Win32_Logicaldisk.DeviceID='g:'");

			// Get Parameters for the method you wish to call
			ManagementBaseObject inParams = mo.GetMethodParameters("Chkdsk");
			// Set all parameters
			inParams["FixErrors"] = false;
			inParams["ForceDismount"] = false;
			inParams["OkToRunAtBootUp"] = false;
			inParams["RecoverBadSectors"] = false;
			inParams["SkipFolderCycle"] = false;
			inParams["VigorousIndexCheck"] = false;

			// Call the method
			Print("Calling CHKDSK on drive " + mo["Name"]);
			ManagementBaseObject outParams = mo.InvokeMethod("Chkdsk", inParams, null);

			// Get the return value
			UInt32 wert = System.Convert.ToUInt32(outParams.Properties["ReturnValue"].Value);
			Print("Result: " + wert.ToString());

			// Alternative with Array of Object
			//      object[] someParams = { false, false, false, false, false, false };
			//      SV.PrintSubHeader("Aufruf von CHKDSK...#2");
			//      object ergebnis = mo.InvokeMethod("Chkdsk", someParams);
			//      SV.Print("Ergebnis von CHKDSK: " + ergebnis.ToString());
		}


		private void Print(string s)
		{
			Demo.Print(s);
		}

		private void PrintHeader(string s)
		{
			Demo.Print("--------------------");
			Demo.Print(s);
			Demo.Print("--------------------");
		}
	}
}
