// Demo for TechEd 2004
// Author: Dr. Holger Schwichtenberg
// http://www.IT-Visions.de

using System;
using System.Management;
using System.Windows.Forms;
using de.ITVisions.DemoViewer;

namespace de.ITVisions.TechEd2004.Samples 
{
 [Demo]
	public class CustomEventConsumer
	{

		public void Ueberwache_DienstAenderung() 
		{
			string query = "SELECT * FROM __InstanceModificationEvent within 1 WHERE TargetInstance ISA 'Win32_Service'";
   WMIQuery(query);
		}

  		public void Ueberwache_LaufwerkAenderung() 
		{
			string query = "SELECT * FROM __InstanceModificationEvent WITHIN 1 WHERE TargetInstance ISA 'Win32_LogicalDisk'";
   WMIQuery(query);
		}


  		public void Ueberwache_SystemAenderung() 
		{
			string query = "SELECT * from Win32_SystemConfigurationChangeEvent within 5";
   WMIQuery(query);
		}


  private void WMIQuery(string query)
  {
   string wminamespace = @"\root\cimv2";
   // Create event query
   EventQuery eq = new EventQuery(query);
   // Creater Watcher
   ManagementEventWatcher watcher = new ManagementEventWatcher(wminamespace, query, null);
   // Set event handler
   watcher.EventArrived += new EventArrivedEventHandler(watcher_EventArrived);
   // Start watching
   watcher.Start();
   Demo.Print("Custom event consumer is now listing for events... " + query);
   // Keep this process alive
   MessageBox.Show("Click here to stop consumer!");
   // Stop Watcher
   watcher.Stop();
  }

		private void watcher_EventArrived(object sender, EventArrivedEventArgs e) 
		{
			// Get the event object
			ManagementBaseObject objEvent = e.NewEvent;
		 Demo.Print("Fired Event: " + objEvent.ClassPath.Path);
			// Information about the object that fired the event
			ManagementBaseObject mo = (ManagementBaseObject) objEvent.GetPropertyValue("PreviousInstance");
			 Demo.Print("Object that fired the event: " + mo.ClassPath.Path);
		 Demo.Print("Details:");
			// List all properties
			foreach (PropertyData p in mo.Properties) 
			{
				if ( p.Value != null )
					 Demo.Print(p.Name + "=" + p.Value.ToString());
				else
					 Demo.Print(p.Name + "= (empty)");
			}
		}
	}
}
