﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using System.IO.Compression;
using System.IO;
using de.ITVisions.DemoViewer;
//TODO: Sample aus MSDN. .zip-File erstellen geht noch nicht :-(
namespace NET2.FCL
{

 [de.ITVisions.DemoViewer.Demo]
 public class SystemIODemo
	{
		public SystemIODemo()
		{

		const string DATEINAME = @"c:\test.doc";
		const string DATEINAME2 = @"c:\test.zip";
	

			FileStream fs = new FileStream(DATEINAME, FileMode.Open, FileAccess.Read, FileShare.Read);
		byte[] buffer = new byte[fs.Length];

		FileStream fs2 = new FileStream(DATEINAME2, FileMode.Create, FileAccess.Write, FileShare.Read);
		GZipStream gzs = new GZipStream(fs2, CompressionMode.Compress);
		gzs.Write(buffer,0,buffer.Length);

		Demo.Print("Datei komprimiert!");



		}

		public  void GZipCompressDecompress(string filename)
		{
			Demo.Print("Test compression and decompression on file {0}", filename);
			FileStream infile;
			try
			{
				// Open the file as a FileStream object.
				infile = new FileStream(filename, FileMode.Open, FileAccess.Read, FileShare.Read);
				byte[] buffer = new byte[infile.Length];
				// Read the file to ensure it is readable.
				int count = infile.Read(buffer, 0, buffer.Length);
				if (count != buffer.Length)
				{
					infile.Close();
					Demo.Print("Test Failed: Unable to read data from file");
					return;
				}
				infile.Close();
				MemoryStream ms = new MemoryStream();
				// Use the newly created memory stream for the compressed data.
				GZipStream compressedzipStream = new GZipStream(ms, CompressionMode.Compress, true);
				Demo.Print("Compression");
				compressedzipStream.Write(buffer, 0, buffer.Length);
				// Close the stream.
				compressedzipStream.Close();
				Demo.Print("Original size: {0}, Compressed size: {1}", buffer.Length, ms.Length);

				// Reset the memory stream position to begin decompression.
				ms.Position = 0;
				GZipStream zipStream = new GZipStream(ms, CompressionMode.Decompress);
				Demo.Print("Decompression");
				byte[] decompressedBuffer = new byte[buffer.Length + 100];
				// Use the ReadAllBytesFromStream to read the stream.
				int totalCount = this.ReadAllBytesFromStream(zipStream, decompressedBuffer);
				Demo.Print("Decompressed {0} bytes", totalCount);

				if (!this.CompareData(buffer, buffer.Length, decompressedBuffer, totalCount))
				{
					Demo.Print("Error. The two buffers did not compare.");
				}
				zipStream.Close();
			} // end try
			catch (InvalidDataException)
			{
				Demo.Print("Error: The file being read contains invalid data.");
			}
			catch (FileNotFoundException)
			{
				Demo.Print("Error:The file specified was not found.");
			}
			catch (ArgumentException)
			{
				Demo.Print("Error: path is a zero-length string, contains only white space, or contains one or more invalid characters");
			}
			catch (PathTooLongException)
			{
				Demo.Print("Error: The specified path, file name, or both exceed the system-defined maximum length. For example, on Windows-based platforms, paths must be less than 248 characters, and file names must be less than 260 characters.");
			}
			catch (DirectoryNotFoundException)
			{
				Demo.Print("Error: The specified path is invalid, such as being on an unmapped drive.");
			}
			catch (IOException)
			{
				Demo.Print("Error: An I/O error occurred while opening the file.");
			}
			catch (UnauthorizedAccessException)
			{
				Demo.Print("Error: path specified a file that is read-only, the path is a directory, or caller does not have the required permissions.");
			}
			catch (IndexOutOfRangeException)
			{
				Demo.Print("Error: You must provide parameters for MyGZIP.");
			}
		}




		public  int ReadAllBytesFromStream(Stream stream, byte[] buffer) 
	{
	// Use this method is used to read all bytes from a stream.
	int offset = 0;
	int totalCount = 0;
		while (true) 
		{
		int bytesRead = stream.Read(buffer, offset, 100); 
			if ( bytesRead == 0) 
			{
			break; 
			}
	offset += bytesRead;
	totalCount += bytesRead; 
		}
	return totalCount;
	} 

	public  bool CompareData(byte[] buf1, int len1, byte[] buf2, int len2) 
	{
		// Use this method to compare data from two different buffers.
		if (len1 != len2) 
		{ 
		Demo.Print("Number of bytes in two buffer are different {0}:{1}", len1, len2);
		return false;
		}

		for ( int i= 0; i< len1; i++) 
		{
			if ( buf1[i] != buf2[i]) 
			{
			Demo.Print("byte {0} is different {1}|{2}", i, buf1[i], buf2[i]);
			return false;
			}
		}
	Demo.Print("All bytes compare.");
	return true; 
	}

}

}