using System;
using System.IO;
using System.Windows.Forms;
using de.ITVisions.DemoViewer;

namespace NET2.FCL {

 [Demo]
  public class Dateisystem {


    [FCL2]
   public void Laufwerke_Auflisten()
   {
    foreach (DriveInfo di in DriveInfo.GetDrives())
    {
     Demo.Print("Laufwerk: " + di.Name);
     if (di.IsReady)
     {
      Demo.Print("  Bezeichnung: " + di.VolumeLabel);
      Demo.Print("  Typ: " + di.DriveType);
      Demo.Print("  Format: " + di.DriveFormat);
      Demo.Print("  Gre: " + di.TotalSize);
      Demo.Print("  Freier Platz: " + di.TotalFreeSpace);
      Demo.Print("  Wurzelordner: " + di.RootDirectory.FullName);
     }
     else
     {
      Demo.Print("  ist nicht bereit!");
     }
    }

   }


   public void Sonderverzeichnisse()
   {
    Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.MyDocuments);
    Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.Desktop);
    Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.CurrentUserApplicationData);
    Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.Programs);
   }


    public void Dateien_Erzeugen() {

      // Erzeugen und Lschen von Textdateien
     string verzeichnis = @"..\..\_daten\dateisystem\";

      // Zugriff auf ein Dateiverzeichnis
      DirectoryInfo d = new DirectoryInfo(verzeichnis);

      // 10 neue Dateien erzeugen
      for (int i=0; i<10; i++) {
        string dateiname = "Datei" + (i+1).ToString() + ".txt";
        FileInfo fi = new FileInfo(d.FullName + @"\" + dateiname);
        if (fi.Exists) {
          // Wenn Datei vorhanden, dann lschen!
          fi.Delete();
          Demo.Print("Datei " + dateiname + " gelscht!");
        }
        fi.Create();
        Demo.Print("Datei " + fi.Name + " erzeugt!");
      }
    }

   [UPDATE("8.12.03")]
    public void Datei_Liste() {
      // Liste der Dateien in einem bestimmten Ordner
      string verzeichnis = Directory.GetCurrentDirectory() + @"\_daten\dateisystem\";
   
      // Zugriff auf ein Dateiverzeichnis
      DirectoryInfo d = new DirectoryInfo(verzeichnis);
    
      // Prfung auf Existenz des Verzeichnisses
      if ( !d.Exists ) {
        Demo.Print("Verzeichnis nicht vorhanden!");
        return;
      }
     
      // Ausgabe von Informationen ber den Ordner
      Demo.Print("Erzeugt am: " + d.CreationTime);
      Demo.Print("Zuletzt gelesen am : " + d.LastAccessTime);
      Demo.Print("Zuletzt gendert am : " + d.LastWriteTime);
      Demo.Print("Wurzelordner: " + d.Root.Name);
      Demo.Print("Name des bergeordneten Ordners: " + d.Parent.Name);
      Demo.Print("Pfad des bergeordneten Ordners: " + d.Parent.FullName);

      // Liste alle  Textdateien in diesem Verzeichnis
      Demo.Print("Alle Text-Dateien in Ordner: " + d.FullName);
      foreach (FileInfo f in d.GetFiles("*.txt"))
        Demo.Print(f.Name + ";" + f.Length + ";" + f.CreationTime);
    }

    public void Datei_Jonglieren() {

     string quelle = @"..\..\_daten\dateisystem\";
     string ziel1 = @"..\..\_daten\dateisystem1\";

      // Zugriff auf ein Dateiverzeichnis
      DirectoryInfo d = new DirectoryInfo(quelle);

      // Bewegen des Verzeichnisses
      d.MoveTo(ziel1);

    }

    public void Datei_Makedir1() {

      // Verzeichnisse anlegen und lschen
     string verzeichnis = @"..\..\_daten\dateisystem\hs\Dokumente\";

      // Zugriff auf ein Dateiverzeichnis
      DirectoryInfo d = new DirectoryInfo(verzeichnis);
      // Verzeichnis erzeugen
      d.Create();

      // Unterverzeichnis erzeugen
      DirectoryInfo sd = d.CreateSubdirectory("1. Halbjahr");
      Demo.Print(sd.FullName + " angelegt!");

      // Unterverzeichnis erzeugen
      sd = d.CreateSubdirectory("2. Halbjahr");
      Demo.Print(sd.FullName + " angelegt!");

      MessageBox.Show("Ordner angelegt!");

      // Verzeichniss rekursiv wieder lschen
      d.Delete(true);
    }

    public void Datei_Makedir2() {

      // Verzeichnis anlegen (VARIANTE)
     string verzeichnis = @"..\..\_daten\dateisystem\hs\Dokumente\";

      // Verzeichnis anlegen
      Directory.CreateDirectory(verzeichnis);
      MessageBox.Show("Ordner angelegt!");
      // Verzeichniss  wieder lschen
      Directory.Delete(verzeichnis, true);
    }


    public void Datei_Bewegen() {

      // Datei kopieren und verschieben
     string docOrdner = @"..\..\_daten\dateisystem\Dokumente\";

      if (Directory.Exists(docOrdner))
        Directory.Delete(docOrdner, true);

      Directory.CreateDirectory(docOrdner);

      Demo.Print("Ordner angelegt!");

      File.Copy(@"..\..\_daten\dateisystem\buch.doc", docOrdner + "\buch.doc");
      Demo.Print("Datei kopiert!");

      File.Delete(@"..\..\_daten\dateisystem\buch.doc");
      Demo.Print("Ausgangsdatei gelscht");

      File.Move(docOrdner + "buch.doc", @"..\..\_daten\dateisystem\buch.doc");
      Demo.Print("Kopie verschoben");

      Directory.Delete(docOrdner, true);
      Demo.Print("Verzeichnis gelscht");
    }
  }
}
