﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

namespace NET2.ConsoleDemo
{
  [de.ITVisions.DemoViewer.Demo]
  public class ConsoleDemo
  {
    public void run()
    {
      // Fenstereigenschaften
      Console.Title = "Konsolendemo (System.Console 2.0)";
      Console.WindowLeft = 0;
      Console.WindowTop = 0;
      Console.SetWindowPosition(0, 0);
      Console.SetWindowSize(50, 30);
      Console.BackgroundColor = ConsoleColor.White;
      Console.ForegroundColor = ConsoleColor.Black;

      Console.WriteLine("Laufschrift");

      // Ausgabe von Informationen über das Fenster
      Console.WriteLine("LargestWindowHeight=" + Console.LargestWindowHeight);
      Console.WriteLine("LargestWindowWidth=" + Console.LargestWindowWidth);

      // Farbe für Schrift
      Console.BackgroundColor = ConsoleColor.White;
      Console.ForegroundColor = ConsoleColor.Red;
      // Fenstergröße

      Console.CursorVisible = false;
      // Ausgabe an bestimmte Stelle platzieren
      Console.BackgroundColor = ConsoleColor.Black;
      Console.ForegroundColor = ConsoleColor.Yellow;

      // Linie zeichnen
      for (int a = 0; a < 20; a++)
      {
        Console.CursorTop = 4 + a;
        Console.CursorLeft = a;
        Console.Write(@"www.dotnetframework.de");
      }

      // Ausgabe über den Bildschirm bewegen
      for (int a = 0; a < 10; a++)
      {
        System.Threading.Thread.Sleep(500);

        Console.MoveBufferArea(a, 4, 50, 30, a + 1, 4);
 
          // Kurzer (länger werdender) hoher Ton
        Console.Beep(10000, (a+1) * 50);
      }

      // Langer tiefer Ton am Ende
      Console.Beep(100, 2000);
      // Warten auf Eingabe
      Console.ReadKey();
    }
  }
}
